/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.dev.ErrorPageGenerators;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import io.quarkus.vertx.http.runtime.devmode.RemoteSyncHandler;
import io.quarkus.vertx.http.runtime.devmode.ReplacementDebugPage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.RoutingContext;

public class VertxHttpHotReplacementSetup
implements HotReplacementSetup {
    private volatile long nextUpdate;
    private HotReplacementContext hotReplacementContext;
    private static final long HOT_REPLACEMENT_INTERVAL = 2000L;
    private static final String HEADER_NAME = "x-quarkus-hot-deployment-done";

    @Override
    public void setupHotDeployment(HotReplacementContext context) {
        System.setProperty("vertxweb.environment", "dev");
        this.hotReplacementContext = context;
        VertxHttpRecorder.setHotReplacement(this::handleHotReplacementRequest, this.hotReplacementContext);
        this.hotReplacementContext.addPreScanStep(new Runnable(){

            @Override
            public void run() {
                RemoteSyncHandler.doPreScan();
            }
        });
    }

    @Override
    public void handleFailedInitialStart() {
        VertxHttpRecorder.startServerAfterFailedStart();
    }

    void handleHotReplacementRequest(final RoutingContext routingContext) {
        if (this.nextUpdate > System.currentTimeMillis() && !this.hotReplacementContext.isTest() || routingContext.request().headers().contains(HEADER_NAME)) {
            if (this.hotReplacementContext.getDeploymentProblem() != null) {
                VertxHttpHotReplacementSetup.handleDeploymentProblem(routingContext, this.hotReplacementContext.getDeploymentProblem());
                return;
            }
            routingContext.next();
            return;
        }
        final ClassLoader current = Thread.currentThread().getContextClassLoader();
        ConnectionBase connectionBase = (ConnectionBase)((Object)routingContext.request().connection());
        connectionBase.getContext().executeBlocking(new Handler<Promise<Boolean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Promise<Boolean> event) {
                Thread.currentThread().setContextClassLoader(current);
                boolean restart = false;
                2 var3_3 = this;
                synchronized (var3_3) {
                    if (VertxHttpHotReplacementSetup.this.nextUpdate < System.currentTimeMillis() || VertxHttpHotReplacementSetup.this.hotReplacementContext.isTest()) {
                        VertxHttpHotReplacementSetup.this.nextUpdate = System.currentTimeMillis() + 2000L;
                        try {
                            restart = VertxHttpHotReplacementSetup.this.hotReplacementContext.doScan(true);
                        }
                        catch (Exception e) {
                            event.fail(new IllegalStateException("Unable to perform hot replacement scanning", e));
                            return;
                        }
                    }
                }
                if (VertxHttpHotReplacementSetup.this.hotReplacementContext.getDeploymentProblem() != null) {
                    event.fail(VertxHttpHotReplacementSetup.this.hotReplacementContext.getDeploymentProblem());
                    return;
                }
                event.complete(restart);
            }
        }, false, new Handler<AsyncResult<Boolean>>(){

            @Override
            public void handle(AsyncResult<Boolean> event) {
                if (event.failed()) {
                    VertxHttpHotReplacementSetup.handleDeploymentProblem(routingContext, event.cause());
                } else {
                    boolean restart = event.result();
                    if (restart) {
                        routingContext.request().headers().set(VertxHttpHotReplacementSetup.HEADER_NAME, "true");
                        VertxHttpRecorder.getRootHandler().handle(routingContext.request());
                    } else {
                        routingContext.next();
                    }
                }
            }
        });
    }

    public static void handleDeploymentProblem(RoutingContext routingContext, Throwable exception) {
        String bodyText = ReplacementDebugPage.generateHtml(exception);
        HttpServerResponse response = routingContext.response();
        response.setStatusCode(500);
        response.headers().add("Content-Type", "text/html; charset=UTF-8");
        response.end(bodyText);
    }

    @Override
    public void close() {
        ErrorPageGenerators.clear();
        VertxHttpRecorder.shutDownDevMode();
    }
}

