/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;

public class SysPropConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = 9167738611308785403L;
    private static final int DEFAULT_ORDINAL = 400;

    public SysPropConfigSource() {
        super("SysPropConfigSource", ConfigSourceUtil.getOrdinalFromMap(SysPropConfigSource.getSystemProperties(), 400));
    }

    @Override
    public Map<String, String> getProperties() {
        return SysPropConfigSource.getSystemProperties();
    }

    @Override
    public String getValue(String s) {
        return AccessController.doPrivileged(() -> System.getProperty(s));
    }

    private static Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(ConfigSourceUtil.propertiesToMap(AccessController.doPrivileged(System::getProperties)));
    }
}

