/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.Function;
import java.util.function.Predicate;

public class UniOnFailureFlatMap<I>
extends UniOperator<I, I> {
    private final Function<? super Throwable, Uni<? extends I>> mapper;
    private final Predicate<? super Throwable> predicate;

    public UniOnFailureFlatMap(Uni<I> upstream, Predicate<? super Throwable> predicate, Function<? super Throwable, Uni<? extends I>> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(UniSubscriber<? super I> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnFailureFlatMapProcessor(subscriber));
    }

    private class UniOnFailureFlatMapProcessor
    extends UniOperatorProcessor<I, I> {
        private volatile UniSubscription innerSubscription;

        public UniOnFailureFlatMapProcessor(UniSubscriber<? super I> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            if (this.upstream.get() == null) {
                super.onSubscribe(subscription);
            } else if (this.innerSubscription == null) {
                this.innerSubscription = subscription;
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (this.isCancelled()) {
                Infrastructure.handleDroppedException(failure);
                return;
            }
            if (this.innerSubscription == null) {
                this.dispatch(failure);
            } else {
                this.downstream.onFailure(failure);
            }
        }

        @Override
        public void cancel() {
            if (this.innerSubscription != null) {
                this.innerSubscription.cancel();
            }
            super.cancel();
        }

        private void dispatch(Throwable failure) {
            boolean test2;
            try {
                test2 = UniOnFailureFlatMap.this.predicate.test(failure);
            }
            catch (Throwable err) {
                this.downstream.onFailure(new CompositeException(failure, err));
                return;
            }
            if (test2) {
                this.performInnerSubscription(failure);
            } else {
                this.downstream.onFailure(failure);
            }
        }

        private void performInnerSubscription(Throwable failure) {
            Uni uni;
            try {
                uni = (Uni)UniOnFailureFlatMap.this.mapper.apply(failure);
            }
            catch (Throwable err) {
                this.downstream.onFailure(new CompositeException(failure, err));
                return;
            }
            if (uni == null) {
                this.downstream.onFailure(new NullPointerException("The mapper returned `null`"));
                return;
            }
            AbstractUni.subscribe(uni, this);
        }
    }
}

