/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.microprofile.config.ResteasyConfigProvider;
import org.jboss.resteasy.plugins.interceptors.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class RegisterBuiltin {
    private static final Map<ClassLoader, ResteasyProviderFactory> configuredClientFactories = new WeakHashMap<ClassLoader, ResteasyProviderFactory>();
    private static final boolean gzipForCachedFactories = RegisterBuiltin.isGZipEnabled();

    public static synchronized ResteasyProviderFactory getClientInitializedResteasyProviderFactory(ClassLoader cl) {
        ResteasyProviderFactory rpf = null;
        boolean gzip = RegisterBuiltin.isGZipEnabled();
        if (gzipForCachedFactories == gzip) {
            rpf = configuredClientFactories.get(cl);
        }
        if (rpf == null) {
            rpf = new ResteasyProviderFactoryImpl(RuntimeType.CLIENT){

                @Override
                public RuntimeType getRuntimeType() {
                    return RuntimeType.CLIENT;
                }
            };
            if (!rpf.isBuiltinsRegistered()) {
                RegisterBuiltin.register(rpf);
            }
            if (gzipForCachedFactories == gzip) {
                configuredClientFactories.put(cl, rpf);
            }
        }
        return rpf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ResteasyProviderFactory factory) {
        ResteasyProviderFactory monitor;
        ResteasyProviderFactory resteasyProviderFactory = monitor = factory instanceof ThreadLocalResteasyProviderFactory ? ((ThreadLocalResteasyProviderFactory)factory).getDelegate() : factory;
        synchronized (resteasyProviderFactory) {
            if (factory.isBuiltinsRegistered() || !factory.isRegisterBuiltins()) {
                return;
            }
            try {
                RegisterBuiltin.registerProviders(factory);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            factory.setBuiltinsRegistered(true);
        }
    }

    public static void registerProviders(ResteasyProviderFactory factory) throws Exception {
        Map<String, URL> origins = RegisterBuiltin.scanBuiltins();
        for (Map.Entry<String, URL> entry : origins.entrySet()) {
            final String line = entry.getKey();
            try {
                Class clazz = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader().loadClass(line) : (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        return Thread.currentThread().getContextClassLoader().loadClass(line);
                    }
                });
                factory.registerProvider(clazz, true);
            }
            catch (NoClassDefFoundError e) {
                LogMessages.LOGGER.noClassDefFoundErrorError(line, entry.getValue(), e);
            }
            catch (ClassNotFoundException | PrivilegedActionException ex) {
                LogMessages.LOGGER.classNotFoundException(line, entry.getValue(), ex);
            }
        }
        if (RegisterBuiltin.isGZipEnabled()) {
            factory.registerProvider(GZIPDecodingInterceptor.class, true);
            factory.registerProvider(GZIPEncodingInterceptor.class, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, URL> scanBuiltins() throws IOException, PrivilegedActionException {
        Enumeration<URL> en = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader().getResources("META-INF/services/" + Providers.class.getName()) : AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

            @Override
            public Enumeration<URL> run() throws IOException {
                return Thread.currentThread().getContextClassLoader().getResources("META-INF/services/" + Providers.class.getName());
            }
        });
        HashMap<String, URL> origins = new HashMap<String, URL>();
        while (en.hasMoreElements()) {
            final URL url = en.nextElement();
            try (InputStream is = System.getSecurityManager() == null ? url.openStream() : AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return url.openStream();
                }
            });){
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).equals("")) continue;
                    origins.put(line, url);
                }
            }
        }
        return origins;
    }

    public static boolean isGZipEnabled() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String value = ResteasyConfigProvider.getConfig().getOptionalValue("resteasy.allowGzip", String.class).orElse(null);
                if ("".equals(value)) {
                    return Boolean.FALSE;
                }
                return Boolean.parseBoolean(value);
            }
        });
    }
}

