/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.redis;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.redisearch.Client;
import io.redisearch.Document;
import io.redisearch.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.redis.JsonUtils;
import org.kie.kogito.persistence.redis.RedisQuery;
import org.kie.kogito.persistence.redis.Sanitizer;
import org.kie.kogito.persistence.redis.index.RedisIndexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisStorage<V>
implements Storage<String, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisStorage.class);
    private final Client redisClient;
    private final RedisIndexManager redisIndexManager;
    private final String indexName;
    private final Class<V> type;

    public RedisStorage(Client redisClient, RedisIndexManager redisIndexManager, String indexName, Class<V> type) {
        this.redisClient = redisClient;
        this.redisIndexManager = redisIndexManager;
        this.indexName = indexName;
        this.type = type;
    }

    @Override
    public void addObjectCreatedListener(Consumer<V> consumer) {
        throw new UnsupportedOperationException("addObjectCreatedListener operation is not supported for Redis yet.");
    }

    @Override
    public void addObjectUpdatedListener(Consumer<V> consumer) {
        throw new UnsupportedOperationException("addObjectUpdatedListener operation is not supported for Redis yet.");
    }

    @Override
    public void addObjectRemovedListener(Consumer<String> consumer) {
        throw new UnsupportedOperationException("addObjectRemovedListener operation is not supported for Redis yet.");
    }

    @Override
    public org.kie.kogito.persistence.api.query.Query<V> query() {
        return new RedisQuery<V>(this.redisClient, this.indexName, this.type);
    }

    @Override
    public V get(String key) {
        Document document = this.redisClient.getDocument(key);
        try {
            return document == null ? null : (V)JsonUtils.getMapper().readValue((String)document.get("rawObject"), this.type);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Could not deserialize the requested object.", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public V put(String key, V value) {
        HashMap<String, Object> document = new HashMap<String, Object>();
        List<String> indexedFields = this.redisIndexManager.getSchema(this.indexName);
        if (indexedFields.size() > 0) {
            Map mappedValue = JsonUtils.getMapper().convertValue(value, Map.class);
            for (String fieldName : indexedFields) {
                if (mappedValue.get(fieldName) == null) continue;
                document.put(fieldName, Sanitizer.sanitize(mappedValue.get(fieldName)));
            }
        }
        document.put("indexName", this.indexName);
        try {
            document.put("rawObject", JsonUtils.getMapper().writeValueAsString(value));
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Could not serialize the object.", e);
            throw new RuntimeException(e);
        }
        this.redisClient.addDocument(key, document);
        return value;
    }

    @Override
    public V remove(String key) {
        V value = this.get(key);
        this.redisClient.deleteDocument(key);
        return value;
    }

    @Override
    public boolean containsKey(String key) {
        return this.redisClient.getDocument(key) != null;
    }

    @Override
    public Map<String, V> entries() {
        throw new UnsupportedOperationException("entrySet operation not supported for Redis.");
    }

    @Override
    public void clear() {
        List<Document> documents = this.redisClient.search((Query)new Query((String)String.format((String)"@%s:%s", (Object[])new Object[]{"indexName", this.indexName}))).docs;
        for (Document doc : documents) {
            this.redisClient.deleteDocument(doc.getId());
        }
    }

    @Override
    public String getRootType() {
        return this.type.getSimpleName();
    }
}

