/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.api;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.jboss.resteasy.annotations.jaxrs.PathParam;
import org.kie.kogito.trusty.service.common.TrustyService;
import org.kie.kogito.trusty.service.common.requests.CounterfactualRequest;
import org.kie.kogito.trusty.service.common.responses.CounterfactualRequestResponse;
import org.kie.kogito.trusty.service.common.responses.DecisionStructuredInputsResponse;
import org.kie.kogito.trusty.service.common.responses.SalienciesResponse;
import org.kie.kogito.trusty.storage.api.model.BaseExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.CounterfactualExplainabilityRequest;
import org.kie.kogito.trusty.storage.api.model.CounterfactualSearchDomain;
import org.kie.kogito.trusty.storage.api.model.LIMEExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.TypedVariableWithValue;

@Path(value="executions/decisions")
public class ExplainabilityApiV1 {
    @Inject
    TrustyService trustyService;

    @GET
    @Path(value="/{executionId}/explanations/saliencies")
    @APIResponses(value={@APIResponse(description="Gets the local explanation of a decision.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=SalienciesResponse.class))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Returns the saliencies for a decision.", description="Returns the saliencies for a particular decision calculated using the lime algorithm.")
    @Produces(value={"application/json"})
    public Response getSaliencies(@Parameter(name="executionId", description="The execution ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="executionId") String executionId) {
        return this.retrieveExplainabilityResult(executionId, LIMEExplainabilityResult.class).map(obj -> Response.ok(new SalienciesResponse((LIMEExplainabilityResult)obj)).build()).orElseGet(() -> Response.status(Response.Status.BAD_REQUEST.getStatusCode()).build());
    }

    private <T extends BaseExplainabilityResult> Optional<T> retrieveExplainabilityResult(String executionId, Class<T> type) {
        try {
            return Optional.ofNullable(this.trustyService.getExplainabilityResultById(executionId, type));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    @POST
    @Path(value="/{executionId}/explanations/counterfactuals")
    @APIResponses(value={@APIResponse(description="UUID, counterfactualId, for the calculation request.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=CounterfactualRequestResponse.class))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Request calculation of the counterfactuals for a decision.", description="Requests calculation of the counterfactuals for a particular decision. Results of the calculation can be obtained by GETing /{executionId}/explanations/counterfactuals/{counterfactualId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response requestCounterfactuals(@Parameter(name="executionId", description="The execution ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="executionId") String executionId, @Parameter(name="Counterfactual request", description="The definition of a request to calculate a decision's Counterfactuals.", required=true, schema=@Schema(implementation=CounterfactualRequest.class)) CounterfactualRequest request) {
        List<TypedVariableWithValue> goals = request.getGoals();
        List<CounterfactualSearchDomain> searchDomains = request.getSearchDomains();
        return this.requestCounterfactualsForExecution(executionId, goals, searchDomains).map(obj -> new CounterfactualRequestResponse(obj.getExecutionId(), obj.getCounterfactualId())).map(Response::ok).orElseGet(() -> Response.status(Response.Status.BAD_REQUEST.getStatusCode())).build();
    }

    private Optional<CounterfactualExplainabilityRequest> requestCounterfactualsForExecution(String executionId, List<TypedVariableWithValue> goals, List<CounterfactualSearchDomain> searchDomains) {
        try {
            return Optional.ofNullable(this.trustyService.requestCounterfactuals(executionId, goals, searchDomains));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    @GET
    @Path(value="/{executionId}/explanations/counterfactuals")
    @APIResponses(value={@APIResponse(description="All counterfactuals for a decision.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=DecisionStructuredInputsResponse.class))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Returns all of the counterfactuals for a decision.", description="Returns all of the counterfactuals for a particular decision.")
    @Produces(value={"application/json"})
    public Response getAllCounterfactuals(@Parameter(name="executionId", description="The execution ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="executionId") String executionId) {
        return this.getCounterfactualRequestsForExecution(executionId).map(obj -> obj.stream().map(cf -> new CounterfactualRequestResponse(cf.getExecutionId(), cf.getCounterfactualId())).collect(Collectors.toList())).map(Response::ok).orElseGet(() -> Response.status(Response.Status.BAD_REQUEST.getStatusCode())).build();
    }

    private Optional<List<CounterfactualExplainabilityRequest>> getCounterfactualRequestsForExecution(String executionId) {
        try {
            return Optional.ofNullable(this.trustyService.getCounterfactualRequests(executionId));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    @GET
    @Path(value="/{executionId}/explanations/counterfactuals/{counterfactualId}")
    @APIResponses(value={@APIResponse(description="A specific counterfactuals for a decision.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=DecisionStructuredInputsResponse.class))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Returns a specific counterfactual for a decision.", description="Returns a specific counterfactual for a particular decision.")
    @Produces(value={"application/json"})
    public Response getCounterfactual(@Parameter(name="executionId", description="The execution ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="executionId") String executionId, @Parameter(name="counterfactualId", description="The Counterfactual ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="counterfactualId") String counterfactualId) {
        return this.getCounterfactualForExecution(executionId, counterfactualId).map(obj -> new CounterfactualRequestResponse(obj.getExecutionId(), obj.getCounterfactualId())).map(Response::ok).orElseGet(() -> Response.status(Response.Status.BAD_REQUEST.getStatusCode())).build();
    }

    private Optional<CounterfactualExplainabilityRequest> getCounterfactualForExecution(String executionId, String counterfactualId) {
        try {
            return Optional.ofNullable(this.trustyService.getCounterfactualRequest(executionId, counterfactualId));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }
}

