/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.common.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.explainability.api.FeatureImportanceDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityResultDto;
import org.kie.kogito.explainability.api.SaliencyDto;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.trusty.service.common.handlers.BaseExplainerServiceHandler;
import org.kie.kogito.trusty.storage.api.model.BaseExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.FeatureImportanceModel;
import org.kie.kogito.trusty.storage.api.model.LIMEExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.SaliencyModel;
import org.kie.kogito.trusty.storage.common.TrustyStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LIMEExplainerServiceHandler
extends BaseExplainerServiceHandler<LIMEExplainabilityResult, LIMEExplainabilityResultDto> {
    private static final Logger LOG = LoggerFactory.getLogger(LIMEExplainerServiceHandler.class);

    protected LIMEExplainerServiceHandler() {
    }

    @Inject
    public LIMEExplainerServiceHandler(TrustyStorageService storageService) {
        super(storageService);
    }

    @Override
    public <T extends BaseExplainabilityResult> boolean supports(Class<T> type) {
        return LIMEExplainabilityResult.class.isAssignableFrom(type);
    }

    @Override
    public <T extends BaseExplainabilityResultDto> boolean supportsDto(Class<T> type) {
        return LIMEExplainabilityResultDto.class.isAssignableFrom(type);
    }

    @Override
    public LIMEExplainabilityResult explainabilityResultFrom(LIMEExplainabilityResultDto dto, Decision decision) {
        Map outcomeNameToIdMap = decision == null ? Collections.emptyMap() : decision.getOutcomes().stream().collect(Collectors.toUnmodifiableMap(DecisionOutcome::getOutcomeName, DecisionOutcome::getOutcomeId));
        List<SaliencyModel> saliencies = dto.getSaliencies() == null ? null : dto.getSaliencies().entrySet().stream().map(e -> this.saliencyFrom((String)outcomeNameToIdMap.get(e.getKey()), (String)e.getKey(), (SaliencyDto)e.getValue())).collect(Collectors.toList());
        return new LIMEExplainabilityResult(dto.getExecutionId(), this.statusFrom(dto.getStatus()), dto.getStatusDetails(), saliencies);
    }

    private SaliencyModel saliencyFrom(String outcomeId, String outcomeName, SaliencyDto dto) {
        if (dto == null) {
            return null;
        }
        List featureImportanceModel = dto.getFeatureImportance() == null ? null : dto.getFeatureImportance().stream().map(this::featureImportanceFrom).collect(Collectors.toList());
        return new SaliencyModel(outcomeId, outcomeName, featureImportanceModel);
    }

    private FeatureImportanceModel featureImportanceFrom(FeatureImportanceDto dto) {
        if (dto == null) {
            return null;
        }
        return new FeatureImportanceModel(dto.getFeatureName(), dto.getScore());
    }

    @Override
    public LIMEExplainabilityResult getExplainabilityResultById(String executionId) {
        Storage<String, LIMEExplainabilityResult> storage = this.storageService.getLIMEResultStorage();
        if (!storage.containsKey(executionId)) {
            throw new IllegalArgumentException(String.format("An explainability result with ID %s does not exist in the LIME results storage.", executionId));
        }
        return storage.get(executionId);
    }

    @Override
    public void storeExplainabilityResult(String executionId, LIMEExplainabilityResult result) {
        Storage<String, LIMEExplainabilityResult> storage = this.storageService.getLIMEResultStorage();
        if (storage.containsKey(executionId)) {
            throw new IllegalArgumentException(String.format("An explainability result with ID %s is already present in the LIME results storage.", executionId));
        }
        storage.put(executionId, result);
        LOG.info("Stored LIME explainability result for execution {}", (Object)executionId);
    }
}

