/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class AugmentedIndexView
implements IndexView {
    private final IndexView index;

    public AugmentedIndexView(@NotNull IndexView index) {
        this.index = index;
    }

    public ClassInfo getClass(@NotNull Type type) {
        return this.index.getClassByName(TypeUtil.getName(type));
    }

    public boolean containsClass(@NotNull Type type) {
        return this.getClass(type) != null;
    }

    public ClassInfo getClass(@NotNull Class<?> klazz) {
        return this.index.getClassByName(DotName.createSimple(klazz.getName()));
    }

    @Override
    public Collection<ClassInfo> getKnownClasses() {
        return this.index.getKnownClasses();
    }

    @Override
    public ClassInfo getClassByName(@NotNull DotName className) {
        return this.index.getClassByName(className);
    }

    @Override
    public Collection<ClassInfo> getKnownDirectSubclasses(@NotNull DotName className) {
        return this.index.getKnownDirectSubclasses(className);
    }

    @Override
    public Collection<ClassInfo> getAllKnownSubclasses(@NotNull DotName className) {
        return this.index.getAllKnownSubclasses(className);
    }

    @Override
    public Collection<ClassInfo> getKnownDirectImplementors(@NotNull DotName className) {
        return this.index.getKnownDirectSubclasses(className);
    }

    @Override
    public Collection<ClassInfo> getAllKnownImplementors(@NotNull DotName interfaceName) {
        return this.index.getAllKnownImplementors(interfaceName);
    }

    @Override
    public Collection<AnnotationInstance> getAnnotations(@NotNull DotName annotationName) {
        return this.index.getAnnotations(annotationName);
    }
}

