/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.math.BigDecimal;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class BeanValidationScanner {
    static final BeanValidationScanner INSTANCE = new BeanValidationScanner();
    private final Logger LOG = Logger.getLogger(BeanValidationScanner.class);
    static final BigDecimal NEGATIVE_ONE = BigDecimal.ZERO.subtract(BigDecimal.ONE);
    static final DotName BV_JAVAX = DotName.createComponentized(null, "javax");
    static final DotName BV_BASE = DotName.createComponentized(BV_JAVAX, "validation");
    static final DotName BV_GROUPS = DotName.createComponentized(BV_BASE, "groups");
    static final DotName BV_DEFAULT_GROUP = DotName.createComponentized(BV_GROUPS, "Default");
    static final DotName BV_CONTRAINTS = DotName.createComponentized(BV_BASE, "constraints");
    static final DotName BV_DECIMAL_MAX = DotName.createComponentized(BV_CONTRAINTS, "DecimalMax");
    static final DotName BV_DECIMAL_MIN = DotName.createComponentized(BV_CONTRAINTS, "DecimalMin");
    static final DotName BV_DIGITS = DotName.createComponentized(BV_CONTRAINTS, "Digits");
    static final DotName BV_MAX = DotName.createComponentized(BV_CONTRAINTS, "Max");
    static final DotName BV_MIN = DotName.createComponentized(BV_CONTRAINTS, "Min");
    static final DotName BV_NEGATIVE = DotName.createComponentized(BV_CONTRAINTS, "Negative");
    static final DotName BV_NEGATIVE_OR_ZERO = DotName.createComponentized(BV_CONTRAINTS, "NegativeOrZero");
    static final DotName BV_NOT_BLANK = DotName.createComponentized(BV_CONTRAINTS, "NotBlank");
    static final DotName BV_NOT_EMPTY = DotName.createComponentized(BV_CONTRAINTS, "NotEmpty");
    static final DotName BV_NOT_NULL = DotName.createComponentized(BV_CONTRAINTS, "NotNull");
    static final DotName BV_POSITIVE = DotName.createComponentized(BV_CONTRAINTS, "Positive");
    static final DotName BV_POSITIVE_OR_ZERO = DotName.createComponentized(BV_CONTRAINTS, "PositiveOrZero");
    static final DotName BV_SIZE = DotName.createComponentized(BV_CONTRAINTS, "Size");

    public static void applyConstraints(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        Schema.SchemaType schemaType = schema.getType();
        if (schemaType == null || schema.getRef() != null) {
            return;
        }
        switch (schemaType) {
            case ARRAY: {
                INSTANCE.notNull(target, schema, propertyKey, handler);
                INSTANCE.sizeArray(target, schema);
                INSTANCE.notEmptyArray(target, schema);
                break;
            }
            case BOOLEAN: {
                INSTANCE.notNull(target, schema, propertyKey, handler);
                break;
            }
            case INTEGER: {
                INSTANCE.decimalMax(target, schema);
                INSTANCE.decimalMin(target, schema);
                INSTANCE.digits(target, schema);
                INSTANCE.max(target, schema);
                INSTANCE.min(target, schema);
                INSTANCE.negative(target, schema);
                INSTANCE.negativeOrZero(target, schema);
                INSTANCE.notNull(target, schema, propertyKey, handler);
                INSTANCE.positive(target, schema);
                INSTANCE.positiveOrZero(target, schema);
                break;
            }
            case NUMBER: {
                INSTANCE.decimalMax(target, schema);
                INSTANCE.decimalMin(target, schema);
                INSTANCE.digits(target, schema);
                INSTANCE.max(target, schema);
                INSTANCE.min(target, schema);
                INSTANCE.negative(target, schema);
                INSTANCE.negativeOrZero(target, schema);
                INSTANCE.notNull(target, schema, propertyKey, handler);
                INSTANCE.positive(target, schema);
                INSTANCE.positiveOrZero(target, schema);
                break;
            }
            case OBJECT: {
                INSTANCE.notNull(target, schema, propertyKey, handler);
                INSTANCE.sizeObject(target, schema);
                INSTANCE.notEmptyObject(target, schema);
                break;
            }
            case STRING: {
                INSTANCE.decimalMax(target, schema);
                INSTANCE.decimalMin(target, schema);
                INSTANCE.digits(target, schema);
                INSTANCE.notBlank(target, schema);
                INSTANCE.notNull(target, schema, propertyKey, handler);
                INSTANCE.sizeString(target, schema);
                INSTANCE.notEmptyString(target, schema);
            }
        }
    }

    void decimalMax(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_DECIMAL_MAX);
        if (constraint != null && schema.getMaximum() == null) {
            String decimalValue = JandexUtil.stringValue(constraint, "value");
            try {
                BigDecimal decimal = new BigDecimal(decimalValue);
                schema.setMaximum(decimal);
                Boolean inclusive = JandexUtil.booleanValue(constraint, "inclusive");
                if (schema.getExclusiveMaximum() == null && inclusive != null && !inclusive.booleanValue()) {
                    schema.setExclusiveMaximum(Boolean.TRUE);
                }
            }
            catch (NumberFormatException e) {
                this.LOG.debugv("Annotation value has invalid format: {0}", (Object)decimalValue);
            }
        }
    }

    void decimalMin(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_DECIMAL_MIN);
        if (constraint != null && schema.getMinimum() == null) {
            String decimalValue = JandexUtil.stringValue(constraint, "value");
            try {
                BigDecimal decimal = new BigDecimal(decimalValue);
                schema.setMinimum(decimal);
                Boolean inclusive = JandexUtil.booleanValue(constraint, "inclusive");
                if (schema.getExclusiveMinimum() == null && inclusive != null && !inclusive.booleanValue()) {
                    schema.setExclusiveMinimum(Boolean.TRUE);
                }
            }
            catch (NumberFormatException e) {
                this.LOG.debugv("Annotation value has invalid format: {0}", (Object)decimalValue);
            }
        }
    }

    void digits(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_DIGITS);
        if (constraint != null && schema.getPattern() == null) {
            int integerPart = JandexUtil.intValue(constraint, "integer");
            int fractionPart = JandexUtil.intValue(constraint, "fraction");
            StringBuilder pattern = new StringBuilder(50);
            pattern.append('^');
            if (integerPart > 0) {
                pattern.append("\\d");
                if (integerPart > 1) {
                    pattern.append("{1,").append(integerPart).append('}');
                }
            }
            if (fractionPart > 0) {
                pattern.append("([.]\\d");
                if (fractionPart > 1) {
                    pattern.append("{1,").append(fractionPart).append("}");
                }
                pattern.append(")?");
            }
            pattern.append('$');
            schema.setPattern(pattern.toString());
        }
    }

    void max(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_MAX);
        if (constraint != null && schema.getMaximum() == null) {
            AnnotationValue value = constraint.value("value");
            schema.setMaximum(new BigDecimal(value.asLong()));
        }
    }

    void min(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_MIN);
        if (constraint != null && schema.getMinimum() == null) {
            AnnotationValue value = constraint.value("value");
            schema.setMinimum(new BigDecimal(value.asLong()));
        }
    }

    void negative(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NEGATIVE);
        if (constraint != null && schema.getMaximum() == null) {
            Boolean exclusive = schema.getExclusiveMaximum();
            if (exclusive != null && exclusive.booleanValue()) {
                schema.setMaximum(BigDecimal.ZERO);
            } else {
                schema.setMaximum(NEGATIVE_ONE);
            }
        }
    }

    void negativeOrZero(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NEGATIVE_OR_ZERO);
        if (constraint != null && schema.getMaximum() == null) {
            Boolean exclusive = schema.getExclusiveMaximum();
            if (exclusive != null && exclusive.booleanValue()) {
                schema.setMaximum(BigDecimal.ONE);
            } else {
                schema.setMaximum(BigDecimal.ZERO);
            }
        }
    }

    void notBlank(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_BLANK);
        if (constraint != null) {
            if (schema.getNullable() == null) {
                schema.setNullable(Boolean.FALSE);
            }
            if (schema.getPattern() == null) {
                schema.setPattern("\\S");
            }
        }
    }

    void notEmptyArray(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_EMPTY);
        if (constraint != null && schema.getMinItems() == null) {
            schema.setMinItems(1);
        }
    }

    void notEmptyObject(AnnotationTarget target, Schema schema) {
        if (!this.allowsAdditionalProperties(schema)) {
            return;
        }
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_EMPTY);
        if (constraint != null && schema.getMinProperties() == null) {
            schema.setMinProperties(1);
        }
    }

    void notEmptyString(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_EMPTY);
        if (constraint != null) {
            if (schema.getNullable() == null) {
                schema.setNullable(Boolean.FALSE);
            }
            if (schema.getMinLength() == null) {
                schema.setMinLength(1);
            }
        }
    }

    void notNull(AnnotationTarget target, Schema schema, String propertyKey, RequirementHandler handler) {
        AnnotationInstance constraint = this.getConstraint(target, BV_NOT_NULL);
        if (constraint != null) {
            if (schema.getNullable() == null) {
                schema.setNullable(Boolean.FALSE);
            }
            if (handler != null && propertyKey != null) {
                handler.setRequired(target, propertyKey);
            }
        }
    }

    void positive(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_POSITIVE);
        if (constraint != null && schema.getMinimum() == null) {
            Boolean exclusive = schema.getExclusiveMinimum();
            if (exclusive != null && exclusive.booleanValue()) {
                schema.setMinimum(BigDecimal.ZERO);
            } else {
                schema.setMinimum(BigDecimal.ONE);
            }
        }
    }

    void positiveOrZero(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_POSITIVE_OR_ZERO);
        if (constraint != null && schema.getMinimum() == null) {
            Boolean exclusive = schema.getExclusiveMinimum();
            if (exclusive != null && exclusive.booleanValue()) {
                schema.setMinimum(NEGATIVE_ONE);
            } else {
                schema.setMinimum(BigDecimal.ZERO);
            }
        }
    }

    void sizeArray(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_SIZE);
        if (constraint != null) {
            Integer min = JandexUtil.intValue(constraint, "min");
            Integer max = JandexUtil.intValue(constraint, "max");
            if (min != null && schema.getMinItems() == null) {
                schema.setMinItems(min);
            }
            if (max != null && schema.getMaxItems() == null) {
                schema.setMaxItems(max);
            }
        }
    }

    void sizeObject(AnnotationTarget target, Schema schema) {
        if (!this.allowsAdditionalProperties(schema)) {
            return;
        }
        AnnotationInstance constraint = this.getConstraint(target, BV_SIZE);
        if (constraint != null) {
            Integer min = JandexUtil.intValue(constraint, "min");
            Integer max = JandexUtil.intValue(constraint, "max");
            if (min != null && schema.getMinProperties() == null) {
                schema.setMinProperties(min);
            }
            if (max != null && schema.getMaxProperties() == null) {
                schema.setMaxProperties(max);
            }
        }
    }

    void sizeString(AnnotationTarget target, Schema schema) {
        AnnotationInstance constraint = this.getConstraint(target, BV_SIZE);
        if (constraint != null) {
            Integer min = JandexUtil.intValue(constraint, "min");
            Integer max = JandexUtil.intValue(constraint, "max");
            if (min != null && schema.getMinLength() == null) {
                schema.setMinLength(min);
            }
            if (max != null && schema.getMaxLength() == null) {
                schema.setMaxLength(max);
            }
        }
    }

    boolean allowsAdditionalProperties(Schema schema) {
        Boolean additionalProperties = schema.getAdditionalPropertiesBoolean();
        if (additionalProperties != null) {
            return additionalProperties;
        }
        return schema.getAdditionalPropertiesSchema() != null;
    }

    AnnotationInstance getConstraint(AnnotationTarget target, DotName annotationName) {
        AnnotationInstance constraint = TypeUtil.getAnnotation(target, annotationName);
        if (constraint != null) {
            AnnotationValue groupValue = constraint.value("groups");
            if (groupValue == null) {
                return constraint;
            }
            Type[] groups = groupValue.asClassArray();
            switch (groups.length) {
                case 0: {
                    return constraint;
                }
                case 1: {
                    if (!groups[0].name().equals(BV_DEFAULT_GROUP)) break;
                    return constraint;
                }
            }
        }
        return null;
    }

    public static interface RequirementHandler {
        public void setRequired(AnnotationTarget var1, String var2);
    }
}

