/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlType;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBContextFinder;

public abstract class AbstractJAXBContextFinder
implements JAXBContextFinder {
    protected static final String OBJECT_FACTORY_NAME = ".ObjectFactory";
    @Context
    protected Providers providers;

    public JAXBContext findProvidedJAXBContext(Class<?> type, MediaType mediaType) throws JAXBException {
        JAXBContext jaxb = null;
        ContextResolver<JAXBContext> resolver = this.providers.getContextResolver(JAXBContext.class, mediaType);
        if (resolver != null && (jaxb = resolver.getContext(type)) != null) {
            return jaxb;
        }
        return jaxb;
    }

    public static String getPackageName(Class<?> type) {
        int packageSeparator = type.getName().lastIndexOf(46);
        String packageName = packageSeparator != -1 ? type.getName().substring(0, packageSeparator) : type.getName();
        return packageName;
    }

    public static Class<?> findDefaultObjectFactoryClass(Class<?> type) {
        Class factoryClass;
        XmlType typeAnnotation = type.getAnnotation(XmlType.class);
        if (typeAnnotation == null) {
            return null;
        }
        if (!typeAnnotation.factoryClass().equals(XmlType.DEFAULT.class)) {
            return null;
        }
        final StringBuilder b = new StringBuilder(AbstractJAXBContextFinder.getPackageName(type));
        b.append(OBJECT_FACTORY_NAME);
        try {
            factoryClass = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader().loadClass(b.toString()) : (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader().loadClass(b.toString());
                }
            });
        }
        catch (ClassNotFoundException | PrivilegedActionException e) {
            return null;
        }
        if (factoryClass.isAnnotationPresent(XmlRegistry.class)) {
            return factoryClass;
        }
        return null;
    }

    protected abstract JAXBContext createContextObject(Annotation[] var1, Class ... var2) throws JAXBException;

    protected abstract JAXBContext createContextObject(Annotation[] var1, String var2) throws JAXBException;

    public JAXBContext createXmlTypeContext(Annotation[] parameterAnnotations, Class ... classes) throws JAXBException {
        HashSet<String> packages = new HashSet<String>();
        for (Class type : classes) {
            packages.add(type.getPackage().getName());
        }
        boolean first = true;
        StringBuilder contextPath = new StringBuilder();
        for (String pkg : packages) {
            if (first) {
                first = false;
            } else {
                contextPath.append(':');
            }
            contextPath.append(pkg);
        }
        return this.createContextObject(parameterAnnotations, contextPath.toString());
    }

    @Override
    public JAXBContext createContext(Annotation[] parameterAnnotations, Class ... classes) throws JAXBException {
        Set<Class> classes1 = Collections.emptySet();
        if (classes != null && classes.length != 0) {
            classes1 = new HashSet();
            for (Class type : classes) {
                if (type == null) continue;
                classes1.add(type);
                Class<?> factory = AbstractJAXBContextFinder.findDefaultObjectFactoryClass(type);
                if (factory == null) continue;
                classes1.add(factory);
            }
        }
        Class[] classArray = classes1.toArray(new Class[classes1.size()]);
        return this.createContextObject(parameterAnnotations, classArray);
    }

    public JAXBContextFinder getContext(Class<?> type) {
        return this;
    }

    public static class CacheKey {
        private Class[] classes;
        private int hashCode;

        public CacheKey(Class[] classes) {
            this.classes = classes;
            for (Class clazz : classes) {
                this.hashCode += clazz.hashCode();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.hashCode != cacheKey.hashCode) {
                return false;
            }
            if (this.classes.length != cacheKey.classes.length) {
                return false;
            }
            for (Class clazz : this.classes) {
                boolean found = false;
                for (Class compare : cacheKey.classes) {
                    if (!compare.equals(clazz)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

