/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.util.MediaTypeHelper;

public class ServletUtil {
    public static ResteasyUriInfo extractUriInfo(HttpServletRequest request, String servletPrefix) {
        String contextPath = request.getContextPath();
        if (servletPrefix != null && servletPrefix.length() > 0 && !servletPrefix.equals("/")) {
            if (!contextPath.endsWith("/") && !servletPrefix.startsWith("/")) {
                contextPath = contextPath + "/";
            }
            contextPath = contextPath + servletPrefix;
        }
        String queryString = request.getQueryString();
        StringBuffer builder = request.getRequestURL();
        String absolute = queryString != null && queryString.length() > 0 ? request.getRequestURL().append('?').append(queryString).toString() : request.getRequestURL().toString();
        return new ResteasyUriInfo(absolute, contextPath);
    }

    public static ResteasyHttpHeaders extractHttpHeaders(HttpServletRequest request) {
        MultivaluedMap<String, String> requestHeaders = ServletUtil.extractRequestHeaders(request);
        ResteasyHttpHeaders headers = new ResteasyHttpHeaders(requestHeaders);
        String contentType = request.getContentType();
        if (contentType != null) {
            headers.getMutableHeaders().putSingle("Content-Type", contentType);
        }
        Map<String, Cookie> cookies = ServletUtil.extractCookies(request);
        headers.setCookies(cookies);
        headers.testParsing();
        return headers;
    }

    static Map<String, Cookie> extractCookies(HttpServletRequest request) {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        if (request.getCookies() != null) {
            for (javax.servlet.http.Cookie cookie : request.getCookies()) {
                cookies.put(cookie.getName(), new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion()));
            }
        }
        return cookies;
    }

    public static List<MediaType> extractAccepts(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        List accepts = (List)requestHeaders.get("Accept");
        if (accepts == null) {
            return acceptableMediaTypes;
        }
        for (String accept : accepts) {
            acceptableMediaTypes.addAll(MediaTypeHelper.parseHeader(accept));
        }
        return acceptableMediaTypes;
    }

    public static List<String> extractLanguages(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<String> acceptable = new ArrayList<String>();
        List accepts = (List)requestHeaders.get("Accept-Language");
        if (accepts == null) {
            return acceptable;
        }
        for (String accept : accepts) {
            String[] splits;
            for (String split : splits = accept.split(",")) {
                acceptable.add(split.trim());
            }
        }
        return acceptable;
    }

    public static MultivaluedMap<String, String> extractRequestHeaders(HttpServletRequest request) {
        Headers<String> requestHeaders = new Headers<String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                requestHeaders.add(headerName, headerValue);
            }
        }
        return requestHeaders;
    }
}

