/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.extensions;

import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.extensions.InMemoryFormat;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DistributedTracingExtension {
    private String traceparent;
    private String tracestate;

    public String getTraceparent() {
        return this.traceparent;
    }

    public void setTraceparent(String traceparent) {
        this.traceparent = traceparent;
    }

    public String getTracestate() {
        return this.tracestate;
    }

    public void setTracestate(String tracestate) {
        this.tracestate = tracestate;
    }

    public String toString() {
        return "DistributedTracingExtension{traceparent='" + this.traceparent + '\'' + ", tracestate='" + this.tracestate + '\'' + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.traceparent == null ? 0 : this.traceparent.hashCode());
        result = 31 * result + (this.tracestate == null ? 0 : this.tracestate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistributedTracingExtension other = (DistributedTracingExtension)obj;
        if (this.traceparent == null ? other.traceparent != null : !this.traceparent.equals(other.traceparent)) {
            return false;
        }
        return !(this.tracestate == null ? other.tracestate != null : !this.tracestate.equals(other.tracestate));
    }

    public static Optional<ExtensionFormat> unmarshall(Map<String, String> exts) {
        String traceparent = exts.get("traceparent");
        String tracestate = exts.get("tracestate");
        if (null != traceparent && null != tracestate) {
            DistributedTracingExtension dte = new DistributedTracingExtension();
            dte.setTraceparent(traceparent);
            dte.setTracestate(tracestate);
            InMemoryFormat inMemory = InMemoryFormat.of("distributedTracing", dte, DistributedTracingExtension.class);
            return Optional.of(ExtensionFormat.of(inMemory, new AbstractMap.SimpleEntry<String, String>("traceparent", traceparent), new AbstractMap.SimpleEntry<String, String>("tracestate", tracestate)));
        }
        return Optional.empty();
    }

    public static class Format
    implements ExtensionFormat {
        public static final String IN_MEMORY_KEY = "distributedTracing";
        public static final String TRACE_PARENT_KEY = "traceparent";
        public static final String TRACE_STATE_KEY = "tracestate";
        private final InMemoryFormat memory;
        private final Map<String, String> transport = new HashMap<String, String>();

        public Format(DistributedTracingExtension extension) {
            Objects.requireNonNull(extension);
            this.memory = InMemoryFormat.of(IN_MEMORY_KEY, extension, DistributedTracingExtension.class);
            this.transport.put(TRACE_PARENT_KEY, extension.getTraceparent());
            this.transport.put(TRACE_STATE_KEY, extension.getTracestate());
        }

        @Override
        public InMemoryFormat memory() {
            return this.memory;
        }

        @Override
        public Map<String, String> transport() {
            return this.transport;
        }
    }
}

