/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.format;

import io.cloudevents.Attributes;
import io.cloudevents.CloudEvent;
import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.format.Wire;
import io.cloudevents.format.builder.EventStep;
import io.cloudevents.format.builder.MarshalStep;
import io.cloudevents.fun.AttributeMarshaller;
import io.cloudevents.fun.DataMarshaller;
import io.cloudevents.fun.ExtensionFormatAccessor;
import io.cloudevents.fun.ExtensionMarshaller;
import io.cloudevents.fun.FormatHeaderMapper;
import io.cloudevents.fun.WireBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public final class BinaryMarshaller {
    private BinaryMarshaller() {
    }

    public static <A extends Attributes, T, P, H> AttributeMarshalStep<A, T, P, H> builder() {
        return new Builder();
    }

    private static final class Builder<A extends Attributes, T, P, H>
    implements AttributeMarshalStep<A, T, P, H>,
    ExtensionsAccessorStep<A, T, P, H>,
    ExtensionsStep<A, T, P, H>,
    DataMarshallerStep<A, T, P, H>,
    HeaderMapStep<A, T, P, H>,
    BuilderStep<A, T, P, H>,
    EventStep<A, T, P, H>,
    MarshalStep<P, H> {
        private AttributeMarshaller<A> attributeMarshaller;
        private ExtensionFormatAccessor<A, T> extensionsAccessor;
        private ExtensionMarshaller extensionMarshaller;
        private FormatHeaderMapper<H> headerMapper;
        private DataMarshaller<P, T, H> dataMarshaller;
        private WireBuilder<P, String, H> wireBuilder;
        private Supplier<CloudEvent<A, T>> eventSupplier;

        private Builder() {
        }

        @Override
        public ExtensionsAccessorStep<A, T, P, H> map(AttributeMarshaller<A> marshaller) {
            this.attributeMarshaller = marshaller;
            return this;
        }

        @Override
        public ExtensionsStep<A, T, P, H> map(ExtensionFormatAccessor<A, T> accessor2) {
            this.extensionsAccessor = accessor2;
            return this;
        }

        @Override
        public HeaderMapStep<A, T, P, H> map(ExtensionMarshaller marshaller) {
            this.extensionMarshaller = marshaller;
            return this;
        }

        @Override
        public DataMarshallerStep<A, T, P, H> map(FormatHeaderMapper<H> mapper) {
            this.headerMapper = mapper;
            return this;
        }

        @Override
        public BuilderStep<A, T, P, H> map(DataMarshaller<P, T, H> marshaller) {
            this.dataMarshaller = marshaller;
            return this;
        }

        @Override
        public EventStep<A, T, P, H> builder(WireBuilder<P, String, H> builder) {
            this.wireBuilder = builder;
            return this;
        }

        @Override
        public MarshalStep<P, H> withEvent(Supplier<CloudEvent<A, T>> event) {
            this.eventSupplier = event;
            return this;
        }

        @Override
        public Wire<P, String, H> marshal() {
            CloudEvent<A, T> event = this.eventSupplier.get();
            Map<String, String> attributesMap = this.attributeMarshaller.marshal(event.getAttributes());
            Collection<ExtensionFormat> extensionsFormat = this.extensionsAccessor.extensionsOf(event);
            Map<String, String> extensionsMap = this.extensionMarshaller.marshal(extensionsFormat);
            Map<String, H> headers = this.headerMapper.map(attributesMap, extensionsMap);
            Object payload = null;
            if (event.getData().isPresent()) {
                payload = this.dataMarshaller.marshal(event.getData().get(), headers);
            }
            return this.wireBuilder.build(payload, headers);
        }
    }

    public static interface BuilderStep<A extends Attributes, T, P, H> {
        public EventStep<A, T, P, H> builder(WireBuilder<P, String, H> var1);
    }

    public static interface DataMarshallerStep<A extends Attributes, T, P, H> {
        public BuilderStep<A, T, P, H> map(DataMarshaller<P, T, H> var1);
    }

    public static interface HeaderMapStep<A extends Attributes, T, P, H> {
        public DataMarshallerStep<A, T, P, H> map(FormatHeaderMapper<H> var1);
    }

    public static interface ExtensionsStep<A extends Attributes, T, P, H> {
        public HeaderMapStep<A, T, P, H> map(ExtensionMarshaller var1);
    }

    public static interface ExtensionsAccessorStep<A extends Attributes, T, P, H> {
        public ExtensionsStep<A, T, P, H> map(ExtensionFormatAccessor<A, T> var1);
    }

    public static interface AttributeMarshalStep<A extends Attributes, T, P, H> {
        public ExtensionsAccessorStep<A, T, P, H> map(AttributeMarshaller<A> var1);
    }
}

