/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.common.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.invoke.MethodHandle;
import java.security.Principal;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.x500._private.ElytronMessages;
import org.wildfly.security.x500.util.X500PrincipalUtil;

@TargetClass(value=X500PrincipalUtil.class)
final class Target_org_wildfly_security_x500_util_X500PrincipalUtil {
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    @Alias
    static Class<?> X500_NAME_CLASS;
    @Delete
    static MethodHandle AS_X500_PRINCIPAL_HANDLE;

    Target_org_wildfly_security_x500_util_X500PrincipalUtil() {
    }

    @Substitute
    public static X500Principal asX500Principal(Principal principal, boolean convert) {
        if (convert) {
            try {
                return new X500Principal(principal.getName());
            }
            catch (IllegalArgumentException ignored) {
                ElytronMessages.log.trace("Unable to convert to X500Principal", ignored);
            }
        }
        return null;
    }
}

