/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigInstantiator;
import io.quarkus.runtime.logging.AsyncConfig;
import io.quarkus.runtime.logging.BannerFormatter;
import io.quarkus.runtime.logging.CategoryConfig;
import io.quarkus.runtime.logging.CleanupFilterConfig;
import io.quarkus.runtime.logging.ConsoleConfig;
import io.quarkus.runtime.logging.FileConfig;
import io.quarkus.runtime.logging.LogCleanupFilter;
import io.quarkus.runtime.logging.LogCleanupFilterElement;
import io.quarkus.runtime.logging.LogConfig;
import io.quarkus.runtime.logging.SyslogConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.errormanager.OnlyOnceErrorManager;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.logmanager.handlers.PeriodicRotatingFileHandler;
import org.jboss.logmanager.handlers.PeriodicSizeRotatingFileHandler;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.wildfly.common.net.HostName;
import org.wildfly.common.os.Process;

@Recorder
public class LoggingSetupRecorder {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
    private static final boolean IS_CON_EMU_ANSI = IS_WINDOWS && "ON".equals(System.getenv("ConEmuANSI"));
    private static final boolean IS_CYGWIN = IS_WINDOWS && System.getenv("PWD") != null && System.getenv("PWD").startsWith("/") && !"cygwin".equals(System.getenv("TERM"));
    private static final boolean IS_MINGW_XTERM = IS_WINDOWS && System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW") && "xterm".equals(System.getenv("TERM"));

    public static void handleFailedStart() {
        LogConfig config = new LogConfig();
        ConfigInstantiator.handleObject(config);
        new LoggingSetupRecorder().initializeLogging(config, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null);
    }

    public void initializeLogging(LogConfig config, List<RuntimeValue<Optional<Handler>>> additionalHandlers, List<RuntimeValue<Map<String, Handler>>> additionalNamedHandlers, List<RuntimeValue<Optional<Formatter>>> possibleFormatters, RuntimeValue<Optional<Supplier<String>>> possibleBannerSupplier) {
        Handler syslogHandler;
        Map<String, CategoryConfig> categories = config.categories;
        LogContext logContext = LogContext.getLogContext();
        Logger rootLogger = logContext.getLogger("");
        rootLogger.setLevel(config.level);
        ErrorManager errorManager = new OnlyOnceErrorManager();
        Map<String, CleanupFilterConfig> filters = config.filters;
        ArrayList<LogCleanupFilterElement> filterElements = new ArrayList<LogCleanupFilterElement>(filters.size());
        for (Map.Entry<String, CleanupFilterConfig> entry : filters.entrySet()) {
            filterElements.add(new LogCleanupFilterElement(entry.getKey(), entry.getValue().ifStartsWith));
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>(3 + additionalHandlers.size());
        if (config.console.enable) {
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(config.console, errorManager, filterElements, possibleFormatters, possibleBannerSupplier);
            errorManager = consoleHandler.getErrorManager();
            handlers.add(consoleHandler);
        }
        if (config.file.enable) {
            handlers.add(LoggingSetupRecorder.configureFileHandler(config.file, errorManager, filterElements));
        }
        if (config.syslog.enable && (syslogHandler = LoggingSetupRecorder.configureSyslogHandler(config.syslog, errorManager, filterElements)) != null) {
            handlers.add(syslogHandler);
        }
        Map<String, Handler> namedHandlers = LoggingSetupRecorder.createNamedHandlers(config, possibleFormatters, errorManager, filterElements);
        Map<String, Handler> additionalNamedHandlersMap = additionalNamedHandlers.stream().map(RuntimeValue::getValue).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Handler handler : additionalNamedHandlersMap.values()) {
            handler.setErrorManager(errorManager);
            handler.setFilter(new LogCleanupFilter(filterElements));
        }
        namedHandlers.putAll(additionalNamedHandlersMap);
        for (Map.Entry entry : categories.entrySet()) {
            String name = (String)entry.getKey();
            Logger categoryLogger = logContext.getLogger(name);
            CategoryConfig categoryConfig = (CategoryConfig)entry.getValue();
            if (!categoryConfig.level.isInherited()) {
                categoryLogger.setLevel(categoryConfig.level.getLevel());
            }
            categoryLogger.setUseParentHandlers(categoryConfig.useParentHandlers);
            if (!categoryConfig.handlers.isPresent()) continue;
            this.addNamedHandlersToCategory(categoryConfig, namedHandlers, categoryLogger, errorManager);
        }
        for (RuntimeValue runtimeValue : additionalHandlers) {
            Optional optional = (Optional)runtimeValue.getValue();
            if (!optional.isPresent()) continue;
            Handler handler = (Handler)optional.get();
            handler.setErrorManager(errorManager);
            handler.setFilter(new LogCleanupFilter(filterElements));
            handlers.add(handler);
        }
        InitialConfigurator.DELAYED_HANDLER.setAutoFlush(false);
        InitialConfigurator.DELAYED_HANDLER.setHandlers(handlers.toArray(EmbeddedConfigurator.NO_HANDLERS));
    }

    private static Map<String, Handler> createNamedHandlers(LogConfig config, List<RuntimeValue<Optional<Formatter>>> possibleFormatters, ErrorManager errorManager, List<LogCleanupFilterElement> filterElements) {
        HashMap<String, Handler> namedHandlers = new HashMap<String, Handler>();
        for (Map.Entry<String, ConsoleConfig> entry : config.consoleHandlers.entrySet()) {
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(entry.getValue(), errorManager, filterElements, possibleFormatters, null);
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, consoleHandler, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : config.fileHandlers.entrySet()) {
            Handler fileHandler = LoggingSetupRecorder.configureFileHandler((FileConfig)entry.getValue(), errorManager, filterElements);
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, fileHandler, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : config.syslogHandlers.entrySet()) {
            Handler syslogHandler = LoggingSetupRecorder.configureSyslogHandler((SyslogConfig)entry.getValue(), errorManager, filterElements);
            if (syslogHandler == null) continue;
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, syslogHandler, entry.getKey());
        }
        return namedHandlers;
    }

    private static void addToNamedHandlers(Map<String, Handler> namedHandlers, Handler handler, String handlerName) {
        if (namedHandlers.containsKey(handlerName)) {
            throw new RuntimeException(String.format("Only one handler can be configured with the same name '%s'", handlerName));
        }
        namedHandlers.put(handlerName, handler);
    }

    private void addNamedHandlersToCategory(CategoryConfig categoryConfig, Map<String, Handler> namedHandlers, Logger categoryLogger, ErrorManager errorManager) {
        for (String categoryNamedHandler : categoryConfig.handlers.get()) {
            if (namedHandlers.get(categoryNamedHandler) != null) {
                categoryLogger.addHandler(namedHandlers.get(categoryNamedHandler));
                continue;
            }
            errorManager.error(String.format("Handler with name '%s' is linked to a category but not configured.", categoryNamedHandler), null, 0);
        }
    }

    public void initializeLoggingForImageBuild() {
        if (ImageInfo.inImageBuildtimeCode()) {
            ConsoleHandler handler = new ConsoleHandler(new PatternFormatter("%d{HH:mm:ss,SSS} %-5p [%c{1.}] %s%e%n"));
            handler.setLevel(Level.INFO);
            InitialConfigurator.DELAYED_HANDLER.setAutoFlush(false);
            InitialConfigurator.DELAYED_HANDLER.setHandlers(new Handler[]{handler});
        }
    }

    private static boolean hasColorSupport() {
        if (IS_WINDOWS) {
            return IS_CON_EMU_ANSI || IS_CYGWIN || IS_MINGW_XTERM;
        }
        return System.console() != null;
    }

    private static Handler configureConsoleHandler(ConsoleConfig config, ErrorManager defaultErrorManager, List<LogCleanupFilterElement> filterElements, List<RuntimeValue<Optional<Formatter>>> possibleFormatters, RuntimeValue<Optional<Supplier<String>>> possibleBannerSupplier) {
        ConsoleHandler handler;
        Formatter formatter = null;
        boolean formatterWarning = false;
        for (RuntimeValue<Optional<Formatter>> value : possibleFormatters) {
            Optional<Formatter> val;
            if (formatter != null) {
                formatterWarning = true;
            }
            if (!(val = value.getValue()).isPresent()) continue;
            formatter = val.get();
        }
        if (formatter == null) {
            Supplier<String> bannerSupplier = null;
            if (possibleBannerSupplier != null && possibleBannerSupplier.getValue().isPresent()) {
                bannerSupplier = possibleBannerSupplier.getValue().get();
            }
            if (config.color.orElse(LoggingSetupRecorder.hasColorSupport()).booleanValue()) {
                ColorPatternFormatter colorPatternFormatter = new ColorPatternFormatter(config.darken, config.format);
                formatter = bannerSupplier != null ? new BannerFormatter(colorPatternFormatter, true, bannerSupplier) : colorPatternFormatter;
            } else {
                PatternFormatter patternFormatter = new PatternFormatter(config.format);
                formatter = bannerSupplier != null ? new BannerFormatter(patternFormatter, false, bannerSupplier) : patternFormatter;
            }
        }
        ConsoleHandler consoleHandler = new ConsoleHandler(formatter);
        consoleHandler.setLevel(config.level);
        consoleHandler.setErrorManager(defaultErrorManager);
        consoleHandler.setFilter(new LogCleanupFilter(filterElements));
        ExtHandler extHandler = handler = config.async.enable ? LoggingSetupRecorder.createAsyncHandler(config.async, config.level, consoleHandler) : consoleHandler;
        if (formatterWarning) {
            handler.getErrorManager().error("Multiple formatters were activated", null, 0);
        }
        return handler;
    }

    private static Handler configureFileHandler(FileConfig config, ErrorManager errorManager, List<LogCleanupFilterElement> filterElements) {
        FileHandler handler = new FileHandler();
        FileConfig.RotationConfig rotationConfig = config.rotation;
        if ((rotationConfig.maxFileSize.isPresent() || rotationConfig.rotateOnBoot) && rotationConfig.fileSuffix.isPresent()) {
            PeriodicSizeRotatingFileHandler periodicSizeRotatingFileHandler = new PeriodicSizeRotatingFileHandler();
            periodicSizeRotatingFileHandler.setSuffix(rotationConfig.fileSuffix.get());
            rotationConfig.maxFileSize.ifPresent(memorySize -> periodicSizeRotatingFileHandler.setRotateSize(memorySize.asLongValue()));
            periodicSizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot);
            periodicSizeRotatingFileHandler.setMaxBackupIndex(rotationConfig.maxBackupIndex);
            handler = periodicSizeRotatingFileHandler;
        } else if (rotationConfig.maxFileSize.isPresent()) {
            SizeRotatingFileHandler sizeRotatingFileHandler = new SizeRotatingFileHandler(rotationConfig.maxFileSize.get().asLongValue(), rotationConfig.maxBackupIndex);
            sizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot);
            handler = sizeRotatingFileHandler;
        } else if (rotationConfig.fileSuffix.isPresent()) {
            PeriodicRotatingFileHandler periodicRotatingFileHandler = new PeriodicRotatingFileHandler();
            periodicRotatingFileHandler.setSuffix(rotationConfig.fileSuffix.get());
            handler = periodicRotatingFileHandler;
        }
        PatternFormatter formatter = new PatternFormatter(config.format);
        handler.setFormatter(formatter);
        handler.setAppend(true);
        try {
            handler.setFile(config.path);
        }
        catch (FileNotFoundException e) {
            errorManager.error("Failed to set log file", e, 4);
        }
        handler.setErrorManager(errorManager);
        handler.setLevel(config.level);
        handler.setFilter(new LogCleanupFilter(filterElements));
        if (config.async.enable) {
            return LoggingSetupRecorder.createAsyncHandler(config.async, config.level, handler);
        }
        return handler;
    }

    private static Handler configureSyslogHandler(SyslogConfig config, ErrorManager errorManager, List<LogCleanupFilterElement> filterElements) {
        try {
            SyslogHandler handler = new SyslogHandler(config.endpoint.getHostString(), config.endpoint.getPort());
            handler.setAppName(config.appName.orElse(Process.getProcessName()));
            handler.setHostname(config.hostname.orElse(HostName.getQualifiedHostName()));
            handler.setFacility(config.facility);
            handler.setSyslogType(config.syslogType);
            handler.setProtocol(config.protocol);
            handler.setBlockOnReconnect(config.blockOnReconnect);
            handler.setTruncate(config.truncate);
            handler.setUseCountingFraming(config.useCountingFraming);
            handler.setLevel(config.level);
            PatternFormatter formatter = new PatternFormatter(config.format);
            handler.setFormatter(formatter);
            handler.setErrorManager(errorManager);
            handler.setFilter(new LogCleanupFilter(filterElements));
            if (config.async.enable) {
                return LoggingSetupRecorder.createAsyncHandler(config.async, config.level, handler);
            }
            return handler;
        }
        catch (IOException e) {
            errorManager.error("Failed to create syslog handler", e, 4);
            return null;
        }
    }

    private static AsyncHandler createAsyncHandler(AsyncConfig asyncConfig, Level level, Handler handler) {
        AsyncHandler asyncHandler = new AsyncHandler(asyncConfig.queueLength);
        asyncHandler.setOverflowAction(asyncConfig.overflow);
        asyncHandler.addHandler(handler);
        asyncHandler.setLevel(level);
        return asyncHandler;
    }
}

