/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.discriminator.DiscriminatorReader;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.externaldocs.ExternalDocsReader;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.io.xml.XmlReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.IndexView;

public class SchemaReader {
    private SchemaReader() {
    }

    public static Map<String, Schema> readSchemas(AnnotationScannerContext context, AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.log.annotationsMap("@Schema");
        LinkedHashMap<String, Schema> map = new LinkedHashMap<String, Schema>();
        for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            map.put(name, SchemaFactory.readSchema((IndexView)context.getIndex(), nested));
        }
        return map;
    }

    public static Schema readSchema(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.log.singleJsonObject("Schema");
        String name = JsonUtil.stringProperty(node, "name");
        SchemaImpl schema = new SchemaImpl(name);
        schema.setRef(JsonUtil.stringProperty(node, "$ref"));
        schema.setFormat(JsonUtil.stringProperty(node, "format"));
        schema.setTitle(JsonUtil.stringProperty(node, "title"));
        schema.setDescription(JsonUtil.stringProperty(node, "description"));
        schema.setDefaultValue(JsonUtil.readObject(node.get("default")));
        schema.setMultipleOf(JsonUtil.bigDecimalProperty(node, "multipleOf"));
        schema.setMaximum(JsonUtil.bigDecimalProperty(node, "maximum"));
        schema.setExclusiveMaximum(JsonUtil.booleanProperty(node, "exclusiveMaximum").orElse(null));
        schema.setMinimum(JsonUtil.bigDecimalProperty(node, "minimum"));
        schema.setExclusiveMinimum(JsonUtil.booleanProperty(node, "exclusiveMinimum").orElse(null));
        schema.setMaxLength(JsonUtil.intProperty(node, "maxLength"));
        schema.setMinLength(JsonUtil.intProperty(node, "minLength"));
        schema.setPattern(JsonUtil.stringProperty(node, "pattern"));
        schema.setMaxItems(JsonUtil.intProperty(node, "maxItems"));
        schema.setMinItems(JsonUtil.intProperty(node, "minItems"));
        schema.setUniqueItems(JsonUtil.booleanProperty(node, "uniqueItems").orElse(null));
        schema.setMaxProperties(JsonUtil.intProperty(node, "maxProperties"));
        schema.setMinProperties(JsonUtil.intProperty(node, "minProperties"));
        schema.setRequired(JsonUtil.readStringArray(node.get("required")).orElse(null));
        schema.setEnumeration(JsonUtil.readObjectArray(node.get("enum")).orElse(null));
        schema.setType(SchemaReader.readSchemaType(node.get("type")));
        schema.setItems(SchemaReader.readSchema(node.get("items")));
        schema.setNot(SchemaReader.readSchema(node.get("not")));
        schema.setAllOf(SchemaReader.readSchemaArray(node.get("allOf")).orElse(null));
        schema.setProperties(SchemaReader.readSchemas(node.get("properties")).orElse(null));
        if (node.has("additionalProperties") && node.get("additionalProperties").isObject()) {
            schema.setAdditionalPropertiesSchema(SchemaReader.readSchema(node.get("additionalProperties")));
        } else {
            schema.setAdditionalPropertiesBoolean(JsonUtil.booleanProperty(node, "additionalProperties").orElse(null));
        }
        schema.setReadOnly(JsonUtil.booleanProperty(node, "readOnly").orElse(null));
        schema.setXml(XmlReader.readXML(node.get("xml")));
        schema.setExternalDocs(ExternalDocsReader.readExternalDocs(node.get("externalDocs")));
        schema.setExample(JsonUtil.readObject(node.get("example")));
        schema.setOneOf(SchemaReader.readSchemaArray(node.get("oneOf")).orElse(null));
        schema.setAnyOf(SchemaReader.readSchemaArray(node.get("anyOf")).orElse(null));
        schema.setNot(SchemaReader.readSchema(node.get("not")));
        schema.setDiscriminator(DiscriminatorReader.readDiscriminator(node.get("discriminator")));
        schema.setNullable(JsonUtil.booleanProperty(node, "nullable").orElse(null));
        schema.setWriteOnly(JsonUtil.booleanProperty(node, "writeOnly").orElse(null));
        schema.setDeprecated(JsonUtil.booleanProperty(node, "deprecated").orElse(null));
        ExtensionReader.readExtensions(node, schema);
        return schema;
    }

    private static Schema.SchemaType readSchemaType(JsonNode node) {
        if (node != null && node.isTextual()) {
            String strval = node.asText();
            return Schema.SchemaType.valueOf(strval.toUpperCase());
        }
        return null;
    }

    private static Optional<List<Schema>> readSchemaArray(JsonNode node) {
        if (node != null && node.isArray()) {
            ArrayList<Schema> rval = new ArrayList<Schema>(node.size());
            ArrayNode arrayNode = (ArrayNode)node;
            for (JsonNode arrayItem : arrayNode) {
                rval.add(SchemaReader.readSchema(arrayItem));
            }
            return Optional.of(rval);
        }
        return Optional.empty();
    }

    public static Optional<Map<String, Schema>> readSchemas(JsonNode node) {
        if (node != null && node.isObject()) {
            LinkedHashMap<String, Schema> models = new LinkedHashMap<String, Schema>();
            Iterator<String> fieldNames = node.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = fieldNames.next();
                JsonNode childNode = node.get(fieldName);
                models.put(fieldName, SchemaReader.readSchema(childNode));
            }
            return Optional.of(models);
        }
        return Optional.empty();
    }
}

