/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.annotations.Merge;
import io.smallrye.reactive.messaging.helpers.ClassUtils;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class MediatorConfigurationSupport {
    private final String methodAsString;
    private final Class<?> returnType;
    private final Class<?>[] parameterTypes;
    private final GenericTypeAssignable returnTypeAssignable;
    private final GenericTypeAssignable firstMethodParamTypeAssignable;

    public MediatorConfigurationSupport(String methodAsString, Class<?> returnType, Class<?>[] parameterTypes, GenericTypeAssignable returnTypeAssignable, GenericTypeAssignable firstMethodParamTypeAssignable) {
        this.methodAsString = methodAsString;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.returnTypeAssignable = returnTypeAssignable;
        this.firstMethodParamTypeAssignable = firstMethodParamTypeAssignable;
    }

    public Shape determineShape(List<?> incomingValue, Object outgoingValue) {
        if (!incomingValue.isEmpty() && outgoingValue != null) {
            if (this.isPublisherOrPublisherBuilder(this.returnType) && this.isConsumingAPublisherOrAPublisherBuilder(this.parameterTypes)) {
                return Shape.STREAM_TRANSFORMER;
            }
            return Shape.PROCESSOR;
        }
        if (!incomingValue.isEmpty()) {
            return Shape.SUBSCRIBER;
        }
        return Shape.PUBLISHER;
    }

    private boolean isPublisherOrPublisherBuilder(Class<?> returnType) {
        return ClassUtils.isAssignable(returnType, Publisher.class) || ClassUtils.isAssignable(returnType, PublisherBuilder.class);
    }

    private boolean isConsumingAPublisherOrAPublisherBuilder(Class[] parameterTypes) {
        if (parameterTypes.length >= 1) {
            Class type = parameterTypes[0];
            return ClassUtils.isAssignable(type, Publisher.class) || ClassUtils.isAssignable(type, PublisherBuilder.class);
        }
        return false;
    }

    public Acknowledgment.Strategy processSuppliedAcknowledgement(List<?> incomings, Supplier<Acknowledgment.Strategy> supplier) {
        Acknowledgment.Strategy result = supplier.get();
        if (!incomings.isEmpty()) {
            return result;
        }
        if (result != null) {
            throw ProviderExceptions.ex.definitionExceptionUnsupported("@Outgoing", this.methodAsString);
        }
        return null;
    }

    public ValidationOutput validate(Shape shape, Acknowledgment.Strategy acknowledgment) {
        switch (shape) {
            case SUBSCRIBER: {
                return this.validateSubscriber();
            }
            case PUBLISHER: {
                return this.validatePublisher();
            }
            case PROCESSOR: {
                return this.validateProcessor(acknowledgment);
            }
            case STREAM_TRANSFORMER: {
                return this.validateStreamTransformer(acknowledgment);
            }
        }
        throw ProviderExceptions.ex.illegalStateExceptionForValidate(shape);
    }

    private ValidationOutput validateSubscriber() {
        MediatorConfiguration.Production production = MediatorConfiguration.Production.NONE;
        if (ClassUtils.isAssignable(this.returnType, Subscriber.class) || ClassUtils.isAssignable(this.returnType, SubscriberBuilder.class)) {
            if (this.parameterTypes.length != 0) {
                throw ProviderExceptions.ex.definitionNoParamOnSubscriber("@Incoming", this.methodAsString);
            }
            GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
            if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                throw ProviderExceptions.ex.definitionSubscriberTypeParam("@Incoming", this.methodAsString);
            }
            MediatorConfiguration.Consumption consumption = assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Consumption.STREAM_OF_MESSAGE : MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD;
            return new ValidationOutput(production, consumption);
        }
        if (ClassUtils.isAssignable(this.returnType, CompletionStage.class)) {
            if (this.parameterTypes.length != 1) {
                throw ProviderExceptions.ex.definitionOnParam("@Incoming", this.methodAsString, "CompletionStage");
            }
            return new ValidationOutput(production, ClassUtils.isAssignable(this.parameterTypes[0], Message.class) ? MediatorConfiguration.Consumption.MESSAGE : MediatorConfiguration.Consumption.PAYLOAD);
        }
        if (ClassUtils.isAssignable(this.returnType, Uni.class)) {
            if (this.parameterTypes.length != 1) {
                throw ProviderExceptions.ex.definitionOnParam("@Incoming", this.methodAsString, "Uni");
            }
            return new ValidationOutput(production, ClassUtils.isAssignable(this.parameterTypes[0], Message.class) ? MediatorConfiguration.Consumption.MESSAGE : MediatorConfiguration.Consumption.PAYLOAD);
        }
        if (this.parameterTypes.length == 1) {
            MediatorConfiguration.Consumption consumption;
            Class<?> param = this.parameterTypes[0];
            MediatorConfiguration.Consumption consumption2 = consumption = ClassUtils.isAssignable(param, Message.class) ? MediatorConfiguration.Consumption.MESSAGE : MediatorConfiguration.Consumption.PAYLOAD;
            if (consumption == MediatorConfiguration.Consumption.MESSAGE) {
                throw ProviderExceptions.ex.definitionBlockingAcknowledgment("@Incoming", this.methodAsString);
            }
            return new ValidationOutput(production, consumption);
        }
        throw ProviderExceptions.ex.definitionUnsupportedSignature("@Incoming", this.methodAsString);
    }

    private ValidationOutput validatePublisher() {
        MediatorConfiguration.Consumption consumption = MediatorConfiguration.Consumption.NONE;
        if (this.returnType == Void.TYPE) {
            throw ProviderExceptions.ex.definitionNotVoid("@Outgoing", this.methodAsString);
        }
        if (this.parameterTypes.length != 0) {
            throw ProviderExceptions.ex.definitionNoParametersExpected("@Outgoing", this.methodAsString);
        }
        if (ClassUtils.isAssignable(this.returnType, Publisher.class)) {
            GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
            if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                throw ProviderExceptions.ex.definitionMustDeclareParam("@Outgoing", this.methodAsString, "Publisher");
            }
            return new ValidationOutput(assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.STREAM_OF_MESSAGE : MediatorConfiguration.Production.STREAM_OF_PAYLOAD, consumption);
        }
        if (ClassUtils.isAssignable(this.returnType, PublisherBuilder.class)) {
            GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
            if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                throw ProviderExceptions.ex.definitionMustDeclareParam("@Outgoing", this.methodAsString, "PublisherBuilder");
            }
            return new ValidationOutput(assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.STREAM_OF_MESSAGE : MediatorConfiguration.Production.STREAM_OF_PAYLOAD, consumption, true);
        }
        if (ClassUtils.isAssignable(this.returnType, Message.class)) {
            return new ValidationOutput(MediatorConfiguration.Production.INDIVIDUAL_MESSAGE, consumption);
        }
        if (ClassUtils.isAssignable(this.returnType, CompletionStage.class)) {
            GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
            if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                throw ProviderExceptions.ex.definitionMustDeclareParam("@Outgoing", this.methodAsString, "CompletionStage");
            }
            return new ValidationOutput(assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.COMPLETION_STAGE_OF_MESSAGE : MediatorConfiguration.Production.COMPLETION_STAGE_OF_PAYLOAD, consumption);
        }
        if (ClassUtils.isAssignable(this.returnType, Uni.class)) {
            GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
            if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                throw ProviderExceptions.ex.definitionMustDeclareParam("@Outgoing", this.methodAsString, "Uni");
            }
            return new ValidationOutput(assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.UNI_OF_MESSAGE : MediatorConfiguration.Production.UNI_OF_PAYLOAD, consumption);
        }
        return new ValidationOutput(MediatorConfiguration.Production.INDIVIDUAL_PAYLOAD, consumption);
    }

    private ValidationOutput validateProcessor(Acknowledgment.Strategy acknowledgment) {
        MediatorConfiguration.Production production;
        MediatorConfiguration.Consumption consumption;
        Boolean useBuilderTypes = null;
        if (ClassUtils.isAssignable(this.returnType, Processor.class) || ClassUtils.isAssignable(this.returnType, ProcessorBuilder.class)) {
            if (this.parameterTypes.length != 0) {
                throw ProviderExceptions.ex.definitionMustNotHaveParams("@Incoming & @Outgoing", this.methodAsString);
            }
            GenericTypeAssignable.Result firstGenericParamOfReturn = this.returnTypeAssignable.check(Message.class, 0);
            if (firstGenericParamOfReturn == GenericTypeAssignable.Result.NotGeneric) {
                throw ProviderExceptions.ex.definitionExpectedTwoParams("@Incoming & @Outgoing", this.methodAsString);
            }
            consumption = firstGenericParamOfReturn == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Consumption.STREAM_OF_MESSAGE : MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD;
            GenericTypeAssignable.Result secondGenericParamOfReturn = this.returnTypeAssignable.check(Message.class, 1);
            if (secondGenericParamOfReturn == GenericTypeAssignable.Result.NotGeneric) {
                throw ProviderExceptions.ex.definitionExpectedTwoParams("@Incoming & @Outgoing", this.methodAsString);
            }
            production = secondGenericParamOfReturn == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.STREAM_OF_MESSAGE : MediatorConfiguration.Production.STREAM_OF_PAYLOAD;
            useBuilderTypes = ClassUtils.isAssignable(this.returnType, ProcessorBuilder.class);
        } else if (ClassUtils.isAssignable(this.returnType, Publisher.class) || ClassUtils.isAssignable(this.returnType, PublisherBuilder.class)) {
            if (this.parameterTypes.length != 1) {
                throw ProviderExceptions.ex.illegalArgumentForValidateProcessor(this.methodAsString);
            }
            GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
            if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                throw ProviderExceptions.ex.definitionExpectedReturnedParam("@Outgoing", this.methodAsString, "Publisher");
            }
            production = assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.STREAM_OF_MESSAGE : MediatorConfiguration.Production.STREAM_OF_PAYLOAD;
            consumption = ClassUtils.isAssignable(this.parameterTypes[0], Message.class) ? MediatorConfiguration.Consumption.STREAM_OF_MESSAGE : MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD;
            useBuilderTypes = ClassUtils.isAssignable(this.returnType, PublisherBuilder.class);
        } else {
            Class<?> param = this.parameterTypes[0];
            if (ClassUtils.isAssignable(this.returnType, CompletionStage.class)) {
                GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
                if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                    throw ProviderExceptions.ex.definitionExpectedReturnedParam("@Incoming & @Outgoing", this.methodAsString, "CompletionStage");
                }
                production = assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.COMPLETION_STAGE_OF_MESSAGE : MediatorConfiguration.Production.COMPLETION_STAGE_OF_PAYLOAD;
                consumption = ClassUtils.isAssignable(param, Message.class) ? MediatorConfiguration.Consumption.MESSAGE : MediatorConfiguration.Consumption.PAYLOAD;
            } else if (ClassUtils.isAssignable(this.returnType, Uni.class)) {
                GenericTypeAssignable.Result assignableToMessageCheck = this.returnTypeAssignable.check(Message.class, 0);
                if (assignableToMessageCheck == GenericTypeAssignable.Result.NotGeneric) {
                    throw ProviderExceptions.ex.definitionExpectedReturnedParam("@Incoming & @Outgoing", this.methodAsString, "Uni");
                }
                production = assignableToMessageCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.UNI_OF_MESSAGE : MediatorConfiguration.Production.UNI_OF_PAYLOAD;
                consumption = ClassUtils.isAssignable(param, Message.class) ? MediatorConfiguration.Consumption.MESSAGE : MediatorConfiguration.Consumption.PAYLOAD;
            } else {
                production = ClassUtils.isAssignable(this.returnType, Message.class) ? MediatorConfiguration.Production.INDIVIDUAL_MESSAGE : MediatorConfiguration.Production.INDIVIDUAL_PAYLOAD;
                MediatorConfiguration.Consumption consumption2 = consumption = ClassUtils.isAssignable(param, Message.class) ? MediatorConfiguration.Consumption.MESSAGE : MediatorConfiguration.Consumption.PAYLOAD;
            }
        }
        if (production == MediatorConfiguration.Production.INDIVIDUAL_MESSAGE && acknowledgment == Acknowledgment.Strategy.POST_PROCESSING) {
            throw ProviderExceptions.ex.illegalStateForValidateProcessor(this.methodAsString);
        }
        return new ValidationOutput(production, consumption, useBuilderTypes);
    }

    private ValidationOutput validateStreamTransformer(Acknowledgment.Strategy acknowledgment) {
        Class<?> paramClass;
        GenericTypeAssignable.Result returnTypeGenericCheck = this.returnTypeAssignable.check(Message.class, 0);
        if (returnTypeGenericCheck == GenericTypeAssignable.Result.NotGeneric) {
            throw ProviderExceptions.ex.definitionExpectedReturnedParam("@Outgoing", this.methodAsString, "Publisher");
        }
        MediatorConfiguration.Production production = returnTypeGenericCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Production.STREAM_OF_MESSAGE : MediatorConfiguration.Production.STREAM_OF_PAYLOAD;
        GenericTypeAssignable.Result firstParamTypeGenericCheck = this.firstMethodParamTypeAssignable.check(Message.class, 0);
        if (firstParamTypeGenericCheck == GenericTypeAssignable.Result.NotGeneric) {
            throw ProviderExceptions.ex.definitionExpectedConsumendParam("@Incoming", this.methodAsString, "Publisher");
        }
        MediatorConfiguration.Consumption consumption = firstParamTypeGenericCheck == GenericTypeAssignable.Result.Assignable ? MediatorConfiguration.Consumption.STREAM_OF_MESSAGE : MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD;
        boolean useBuilderTypes = ClassUtils.isAssignable(this.returnType, PublisherBuilder.class);
        if (acknowledgment == Acknowledgment.Strategy.POST_PROCESSING) {
            throw ProviderExceptions.ex.definitionAutoAckNotSupported("@Incoming & @Outgoing", this.methodAsString);
        }
        if (consumption == MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD && acknowledgment == Acknowledgment.Strategy.MANUAL) {
            throw ProviderExceptions.ex.definitionManualAckNotSupported("@Incoming & @Outgoing", this.methodAsString);
        }
        if (production == MediatorConfiguration.Production.STREAM_OF_PAYLOAD && acknowledgment == Acknowledgment.Strategy.MANUAL) {
            throw ProviderExceptions.ex.definitionManualAckNotSupported("@Incoming & @Outgoing", this.methodAsString);
        }
        if (useBuilderTypes && !ClassUtils.isAssignable(paramClass = this.parameterTypes[0], PublisherBuilder.class)) {
            throw ProviderExceptions.ex.definitionProduceConsume("@Incoming & @Outgoing", this.methodAsString);
        }
        return new ValidationOutput(production, consumption, useBuilderTypes);
    }

    public Acknowledgment.Strategy processDefaultAcknowledgement(Shape shape, MediatorConfiguration.Consumption consumption) {
        if (shape == Shape.STREAM_TRANSFORMER) {
            if (consumption == MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD) {
                return Acknowledgment.Strategy.PRE_PROCESSING;
            }
            return Acknowledgment.Strategy.MANUAL;
        }
        if (shape == Shape.PROCESSOR) {
            if (consumption == MediatorConfiguration.Consumption.PAYLOAD) {
                return Acknowledgment.Strategy.POST_PROCESSING;
            }
            if (consumption == MediatorConfiguration.Consumption.MESSAGE || consumption == MediatorConfiguration.Consumption.STREAM_OF_MESSAGE) {
                return Acknowledgment.Strategy.MANUAL;
            }
            return Acknowledgment.Strategy.PRE_PROCESSING;
        }
        if (shape == Shape.SUBSCRIBER) {
            if (consumption == MediatorConfiguration.Consumption.STREAM_OF_MESSAGE || consumption == MediatorConfiguration.Consumption.MESSAGE) {
                return Acknowledgment.Strategy.MANUAL;
            }
            return Acknowledgment.Strategy.POST_PROCESSING;
        }
        return Acknowledgment.Strategy.POST_PROCESSING;
    }

    public Merge.Mode processMerge(List<?> incomings, Supplier<Merge.Mode> supplier) {
        Merge.Mode result = supplier.get();
        if (incomings != null && !incomings.isEmpty()) {
            return result;
        }
        if (result != null) {
            throw ProviderExceptions.ex.definitionMergeOnlyIncoming("@Outgoing", this.methodAsString);
        }
        return null;
    }

    public Integer processBroadcast(Object outgoing, Supplier<Integer> supplier) {
        Integer result = supplier.get();
        if (outgoing != null) {
            return result;
        }
        if (result != null) {
            throw ProviderExceptions.ex.definitionBroadcastOnlyOutgoing("@Incoming", this.methodAsString);
        }
        return null;
    }

    public void validateBlocking(ValidationOutput validationOutput) {
        if (!(validationOutput.production.equals((Object)MediatorConfiguration.Production.INDIVIDUAL_MESSAGE) || validationOutput.production.equals((Object)MediatorConfiguration.Production.INDIVIDUAL_PAYLOAD) || validationOutput.production.equals((Object)MediatorConfiguration.Production.NONE))) {
            throw ProviderExceptions.ex.definitionBlockingOnlyIndividual("@Blocking", this.methodAsString);
        }
        if (!(validationOutput.consumption.equals((Object)MediatorConfiguration.Consumption.MESSAGE) || validationOutput.consumption.equals((Object)MediatorConfiguration.Consumption.PAYLOAD) || validationOutput.consumption.equals((Object)MediatorConfiguration.Consumption.NONE))) {
            throw ProviderExceptions.ex.definitionBlockingOnlyIndividualParam("@Blocking", this.methodAsString);
        }
        if (ClassUtils.isAssignable(this.returnType, CompletionStage.class)) {
            throw ProviderExceptions.ex.definitionBlockingOnlyIndividual("@Blocking", this.methodAsString);
        }
        if (ClassUtils.isAssignable(this.returnType, Uni.class)) {
            throw ProviderExceptions.ex.definitionBlockingOnlyIndividual("@Blocking", this.methodAsString);
        }
    }

    public static interface GenericTypeAssignable {
        public Result check(Class<?> var1, int var2);

        public static enum Result {
            NotGeneric,
            InvalidIndex,
            NotAssignable,
            Assignable;

        }
    }

    public static class ValidationOutput {
        private final MediatorConfiguration.Production production;
        private final MediatorConfiguration.Consumption consumption;
        private final Boolean useBuilderTypes;

        public ValidationOutput(MediatorConfiguration.Production production, MediatorConfiguration.Consumption consumption) {
            this(production, consumption, null);
        }

        public ValidationOutput(MediatorConfiguration.Production production, MediatorConfiguration.Consumption consumption, Boolean useBuilderTypes) {
            this.production = production;
            this.consumption = consumption;
            this.useBuilderTypes = useBuilderTypes;
        }

        public MediatorConfiguration.Production getProduction() {
            return this.production;
        }

        public MediatorConfiguration.Consumption getConsumption() {
            return this.consumption;
        }

        public Boolean getUseBuilderTypes() {
            return this.useBuilderTypes;
        }
    }
}

