/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.i18n;

import java.util.Map;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="SRMSG", length=5)
public interface KafkaLogging
extends BasicLogger {
    public static final KafkaLogging log = Logger.getMessageLogger(KafkaLogging.class, "io.smallrye.reactive.messaging.kafka");

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18200, value="Merging config with %s")
    public void mergingConfigWith(Map<String, Object> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18201, value="Dead queue letter configured with: topic: `%s`, key serializer: `%s`, value serializer: `%s`")
    public void deadLetterConfig(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18202, value="A message sent to channel `%s` has been nacked, sending the record to a dead letter topic %s")
    public void messageNackedDeadLetter(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18203, value="A message sent to channel `%s` has been nacked, fail-stop")
    public void messageNackedFailStop(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18204, value="A message sent to channel `%s` has been nacked, ignored failure is: %s.")
    public void messageNackedIgnore(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18205, value="The full ignored failure is")
    public void messageNackedFullIgnored(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18206, value="Unable to write to Kafka")
    public void unableToWrite(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18207, value="Unable to dispatch message to Kafka")
    public void unableToDispatch(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18208, value="Ignoring message - no topic set")
    public void ignoringNoTopicSet();

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18209, value="Sending message %s to Kafka topic '%s'")
    public void sendingMessageToTopic(Message var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18210, value="Unable to send a record to Kafka ")
    public void unableToSendRecord(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18211, value="Message %s sent successfully to Kafka topic '%s'")
    public void successfullyToTopic(Message var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18212, value="Message %s was not sent to Kafka topic '%s' - nacking message")
    public void nackingMessage(Message var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18213, value="Setting %s to %s")
    public void configServers(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18214, value="Key deserializer omitted, using String as default")
    public void keyDeserializerOmitted();

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18215, value="An error has been caught while closing the Kafka Write Stream")
    public void errorWhileClosingWriteStream(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18216, value="No `group.id` set in the configuration, generate a random id: %s")
    public void noGroupId(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18217, value="Unable to read a record from Kafka topic '%s'")
    public void unableToReadRecord(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @org.jboss.logging.annotations.Message(id=18218, value="An exception has been caught while closing the Kafka consumer")
    public void exceptionOnClose(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18219, value="Loading KafkaConsumerRebalanceListener from configured name '%s'")
    public void loadingConsumerRebalanceListenerFromConfiguredName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18220, value="Loading KafkaConsumerRebalanceListener from group id '%s'")
    public void loadingConsumerRebalanceListenerFromGroupId(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18221, value="Unable to execute consumer assigned re-balance listener for group '%s'. The consumer has been paused. Will retry until the consumer session times out in which case will resume to force a new re-balance attempt.")
    public void unableToExecuteConsumerAssignedRebalanceListener(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @org.jboss.logging.annotations.Message(id=18222, value="Unable to execute consumer revoked re-balance listener for group '%s'")
    public void unableToExecuteConsumerRevokedRebalanceListener(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18223, value="Executing consumer assigned re-balance listener for group '%s'")
    public void executingConsumerAssignedRebalanceListener(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18224, value="Executing consumer revoked re-balance listener for group '%s'")
    public void executingConsumerRevokedRebalanceListener(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18225, value="Executed consumer assigned re-balance listener for group '%s'")
    public void executedConsumerAssignedRebalanceListener(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @org.jboss.logging.annotations.Message(id=18226, value="Executed consumer revoked re-balance listener for group '%s'")
    public void executedConsumerRevokedRebalanceListener(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @org.jboss.logging.annotations.Message(id=18227, value="Re-enabling consumer for group '%s'. This consumer was paused because of a re-balance failure.")
    public void reEnablingConsumerforGroup(String var1);
}

