/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan.cache;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.persistence.api.factory.StorageQualifier;
import org.kie.kogito.persistence.infinispan.cache.JsonDataFormatMarshaller;
import org.kie.kogito.persistence.infinispan.cache.KogitoCacheDefaultConfiguration;
import org.kie.kogito.persistence.infinispan.cache.StorageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@StorageQualifier(value="infinispan")
public class InfinispanCacheManager
implements StorageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanCacheManager.class);
    @Inject
    JsonDataFormatMarshaller marshaller;
    DataFormat jsonDataFormat;
    @Inject
    @ConfigProperty(name="kogito.cache.domain.template", defaultValue="kogito-template")
    String cacheTemplateName;
    @Inject
    RemoteCacheManager manager;

    @PostConstruct
    public void init() {
        this.jsonDataFormat = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller(this.marshaller).build();
        this.manager.start();
    }

    @PreDestroy
    public void destroy() {
        this.manager.stop();
        try {
            this.manager.close();
        }
        catch (Exception ex) {
            LOGGER.warn("Error trying to close Infinispan remote cache manager", ex);
        }
    }

    protected <K, V> RemoteCache<K, V> getOrCreateCache(String name, String template) {
        try {
            LOGGER.debug("Trying to get cache {} from the server", (Object)name);
            BasicCache remoteCache = this.manager.getCache(name);
            if (remoteCache == null) {
                LOGGER.debug("Cache {} not found, trying to create a new one based on template {}", (Object)name, (Object)template);
                return this.manager.administration().getOrCreateCache(name, template);
            }
            return remoteCache;
        }
        catch (HotRodClientException e) {
            if (e.isServerError()) {
                LOGGER.info("Creating a cache for '{}' based on the default configuration", (Object)name);
                BasicCache cache = this.manager.administration().getOrCreateCache(name, new KogitoCacheDefaultConfiguration(name));
                LOGGER.debug("Default cache created {}", (Object)cache.getName());
                return cache;
            }
            throw e;
        }
    }

    @Override
    public Storage<String, String> getCache(String name) {
        return new StorageImpl<String, String>((RemoteCache<String, String>)this.manager.administration().getOrCreateCache(name, (String)null), String.class.getName());
    }

    @Override
    public <T> Storage<String, T> getCache(String name, Class<T> type) {
        return new StorageImpl(this.getOrCreateCache(name, this.cacheTemplateName), type.getName());
    }

    @Override
    public <T> Storage<String, T> getCacheWithDataFormat(String name, Class<T> type, String rootType) {
        return new StorageImpl(this.getOrCreateCache(name, this.cacheTemplateName).withDataFormat(this.jsonDataFormat), rootType);
    }
}

