/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.trusty.service.ITrustyService;
import org.kie.kogito.trusty.storage.api.TrustyStorageService;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.Execution;

@ApplicationScoped
public class TrustyService
implements ITrustyService {
    private TrustyStorageService storageService;

    TrustyService() {
    }

    @Inject
    public TrustyService(TrustyStorageService storageService) {
        this.storageService = storageService;
    }

    @Override
    public List<Execution> getExecutionHeaders(OffsetDateTime from, OffsetDateTime to, int limit, int offset, String prefix) {
        Storage<String, Decision> storage = this.storageService.getDecisionsStorage();
        ArrayList filters = new ArrayList();
        filters.add(QueryFilterFactory.like("executionId", prefix + "*"));
        filters.add(QueryFilterFactory.greaterThanEqual("executionTimestamp", from.toInstant().toEpochMilli()));
        filters.add(QueryFilterFactory.lessThanEqual("executionTimestamp", to.toInstant().toEpochMilli()));
        return new ArrayList<Execution>(storage.query().limit(limit).offset(offset).filter(filters).execute());
    }

    @Override
    public Decision getDecisionById(String executionId) {
        Storage<String, Decision> storage = this.storageService.getDecisionsStorage();
        if (!storage.containsKey(executionId)) {
            throw new IllegalArgumentException(String.format("A decision with ID %s does not exist in the storage.", executionId));
        }
        return storage.get(executionId);
    }

    @Override
    public void storeDecision(String executionId, Decision decision) {
        Storage<String, Decision> storage = this.storageService.getDecisionsStorage();
        if (storage.containsKey(executionId)) {
            throw new IllegalArgumentException(String.format("A decision with ID %s is already present in the storage.", executionId));
        }
        storage.put(executionId, decision);
    }

    @Override
    public void updateDecision(String executionId, Decision decision) {
        this.storageService.getDecisionsStorage().put(executionId, decision);
    }
}

