/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.stream.Collectors;
import org.kie.kogito.trusty.service.responses.DecisionOutcomeResponse;
import org.kie.kogito.trusty.service.responses.ExecutionHeaderResponse;
import org.kie.kogito.trusty.storage.api.model.Decision;

public class DecisionOutcomesResponse {
    @JsonProperty(value="header")
    private ExecutionHeaderResponse header;
    @JsonProperty(value="outcomes")
    private Collection<DecisionOutcomeResponse> outcomes;

    private DecisionOutcomesResponse() {
    }

    public DecisionOutcomesResponse(ExecutionHeaderResponse header, Collection<DecisionOutcomeResponse> outcomes) {
        this.header = header;
        this.outcomes = outcomes;
    }

    public ExecutionHeaderResponse getHeader() {
        return this.header;
    }

    public Collection<DecisionOutcomeResponse> getOutcomes() {
        return this.outcomes;
    }

    public static DecisionOutcomesResponse from(Decision decision) {
        if (decision == null) {
            return null;
        }
        Collection outcomes = decision.getOutcomes() == null ? null : (Collection)decision.getOutcomes().stream().map(DecisionOutcomeResponse::from).collect(Collectors.toList());
        return new DecisionOutcomesResponse(ExecutionHeaderResponse.fromExecution(decision), outcomes);
    }
}

