/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.responses;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.kie.kogito.trusty.storage.api.model.Execution;
import org.kie.kogito.trusty.storage.api.model.ExecutionTypeEnum;

public class ExecutionHeaderResponse {
    @JsonProperty(value="executionId")
    private String executionId;
    @JsonProperty(value="executionDate")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssZ")
    private OffsetDateTime executionDate;
    @JsonProperty(value="hasSucceeded")
    private boolean hasSucceeded;
    @JsonProperty(value="executorName")
    private String executorName;
    @JsonProperty(value="executedModelName")
    private String executedModelName;
    @JsonProperty(value="executionType")
    private ExecutionTypeEnum executionType;

    private ExecutionHeaderResponse() {
    }

    public ExecutionHeaderResponse(String executionId, OffsetDateTime executionDate, boolean hasSucceeded, String executorName, String executedModelName, ExecutionTypeEnum executionType) {
        this.executionId = executionId;
        this.executionDate = executionDate;
        this.hasSucceeded = hasSucceeded;
        this.executorName = executorName;
        this.executedModelName = executedModelName;
        this.executionType = executionType;
    }

    public static ExecutionHeaderResponse fromExecution(Execution execution) {
        OffsetDateTime ldt = OffsetDateTime.ofInstant(Instant.ofEpochMilli(execution.getExecutionTimestamp()), ZoneOffset.UTC);
        return new ExecutionHeaderResponse(execution.getExecutionId(), ldt, execution.hasSucceeded(), execution.getExecutorName(), execution.getExecutedModelName(), execution.getExecutionType());
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public OffsetDateTime getExecutionDate() {
        return this.executionDate;
    }

    public boolean hasSucceeded() {
        return this.hasSucceeded;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public String getExecutedModelName() {
        return this.executedModelName;
    }

    public ExecutionTypeEnum getExecutionType() {
        return this.executionType;
    }
}

