/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.infinispan;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.ExecutionTypeEnum;
import org.kie.kogito.trusty.storage.api.model.TypedValue;
import org.kie.kogito.trusty.storage.infinispan.AbstractModelMarshaller;

public class DecisionMarshaller
extends AbstractModelMarshaller<Decision> {
    public DecisionMarshaller(ObjectMapper mapper) {
        super(mapper, Decision.class);
    }

    @Override
    public Decision readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        ExecutionTypeEnum executionType = DecisionMarshaller.enumFromString(reader.readString("executionType"), ExecutionTypeEnum.class);
        if (executionType != ExecutionTypeEnum.DECISION) {
            throw new IllegalStateException("Unsupported execution type: " + executionType);
        }
        return new Decision(reader.readString("executionId"), reader.readLong("executionTimestamp"), reader.readBoolean("hasSucceeded"), reader.readString("executorName"), reader.readString("executedModelName"), reader.readCollection("inputs", new ArrayList(), TypedValue.class), reader.readCollection("outcomes", new ArrayList(), DecisionOutcome.class));
    }

    @Override
    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, Decision input) throws IOException {
        writer.writeString("executionType", DecisionMarshaller.stringFromEnum(input.getExecutionType()));
        writer.writeString("executionId", input.getExecutionId());
        writer.writeLong("executionTimestamp", input.getExecutionTimestamp());
        writer.writeBoolean("hasSucceeded", input.hasSucceeded());
        writer.writeString("executorName", input.getExecutorName());
        writer.writeString("executedModelName", input.getExecutedModelName());
        writer.writeCollection("inputs", input.getInputs(), TypedValue.class);
        writer.writeCollection("outcomes", input.getOutcomes(), DecisionOutcome.class);
    }
}

