/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.infinispan;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.infinispan.protostream.FileDescriptorSource;
import org.kie.kogito.trusty.storage.infinispan.DecisionMarshaller;
import org.kie.kogito.trusty.storage.infinispan.DecisionOutcomeMarshaller;
import org.kie.kogito.trusty.storage.infinispan.MessageExceptionFieldMarshaller;
import org.kie.kogito.trusty.storage.infinispan.MessageMarshaller;
import org.kie.kogito.trusty.storage.infinispan.TypedValueMarshaller;

@ApplicationScoped
public class ProtostreamProducer {
    @Inject
    ObjectMapper mapper;

    @Produces
    FileDescriptorSource kogitoTypesDescriptor() throws IOException {
        FileDescriptorSource source = new FileDescriptorSource();
        source.addProtoFile("decision.proto", Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/decision.proto"));
        return source;
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller decisionModelMarshaller() {
        return new DecisionMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller decisionOutcomeModelMarshaller() {
        return new DecisionOutcomeMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller messageExceptionFieldModelMarshaller() {
        return new MessageExceptionFieldMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller messageModelMarshaller() {
        return new MessageMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller typedValueModelMarshaller() {
        return new TypedValueMarshaller(this.mapper);
    }
}

