/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging;

import io.cloudevents.v1.AttributesImpl;
import io.cloudevents.v1.CloudEventImpl;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.kie.kogito.tracing.decision.event.trace.TraceEventType;
import org.kie.kogito.trusty.service.ITrustyService;
import org.kie.kogito.trusty.service.messaging.TraceEventConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TraceEventConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(TraceEventConsumer.class);
    private final ITrustyService service;

    @Inject
    public TraceEventConsumer(ITrustyService service) {
        this.service = service;
    }

    @Incoming(value="kogito-tracing")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        this.decodeCloudEvent((String)message.getPayload()).ifPresent(this::handleCloudEvent);
        return message.ack();
    }

    private Optional<CloudEventImpl<TraceEvent>> decodeCloudEvent(String payload) {
        try {
            return Optional.of(CloudEventUtils.decode((String)payload));
        }
        catch (IllegalStateException e) {
            LOG.error(String.format("Can't decode message to CloudEvent: %s", payload), (Throwable)e);
            return Optional.empty();
        }
    }

    private void handleCloudEvent(CloudEventImpl<TraceEvent> cloudEvent) {
        AttributesImpl attributes = cloudEvent.getAttributes();
        Optional optData = cloudEvent.getData();
        if (!optData.isPresent()) {
            LOG.error("Received CloudEvent with id {} from {} with empty data", (Object)attributes.getId(), (Object)attributes.getSource());
            return;
        }
        LOG.debug("Received CloudEvent with id {} from {}", (Object)attributes.getId(), (Object)attributes.getSource());
        TraceEvent traceEvent = (TraceEvent)optData.get();
        TraceEventType traceEventType = traceEvent.getHeader().getType();
        if (traceEventType == TraceEventType.DMN) {
            this.service.storeDecision(attributes.getId(), TraceEventConverter.toDecision(traceEvent));
        } else {
            LOG.error("Unsupported TraceEvent type {}", (Object)traceEventType);
        }
    }
}

