/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.kie.kogito.trusty.service.responses.MessageExceptionFieldResponse;
import org.kie.kogito.trusty.storage.api.model.Message;

public class MessageResponse {
    @JsonProperty(value="level")
    private String level;
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="sourceId")
    private String sourceId;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="exception")
    private MessageExceptionFieldResponse exception;

    private MessageResponse() {
    }

    public MessageResponse(String level, String category, String type, String sourceId, String text, MessageExceptionFieldResponse exception) {
        this.level = level;
        this.category = category;
        this.type = type;
        this.sourceId = sourceId;
        this.text = text;
        this.exception = exception;
    }

    public String getLevel() {
        return this.level;
    }

    public String getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getText() {
        return this.text;
    }

    public MessageExceptionFieldResponse getException() {
        return this.exception;
    }

    public static MessageResponse from(Message message) {
        if (message == null) {
            return null;
        }
        String level = message.getLevel() == null ? null : message.getLevel().name();
        return new MessageResponse(level, message.getCategory(), message.getType(), message.getSourceId(), message.getText(), MessageExceptionFieldResponse.from(message.getException()));
    }
}

