/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.format;

import io.cloudevents.Attributes;
import io.cloudevents.CloudEvent;
import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.format.Wire;
import io.cloudevents.format.builder.EventStep;
import io.cloudevents.format.builder.MarshalStep;
import io.cloudevents.fun.EnvelopeMarshaller;
import io.cloudevents.fun.ExtensionFormatAccessor;
import io.cloudevents.fun.ExtensionMarshaller;
import io.cloudevents.fun.FormatHeaderMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class StructuredMarshaller {
    StructuredMarshaller() {
    }

    public static <A extends Attributes, T, P, H> MediaTypeStep<A, T, P, H> builder() {
        return new Builder();
    }

    private static final class Builder<A extends Attributes, T, P, H>
    implements MediaTypeStep<A, T, P, H>,
    EnvelopeMarshallerStep<A, T, P, H>,
    ExtensionAccessorStep<A, T, P, H>,
    ExtensionMarshallerStep<A, T, P, H>,
    HeaderMapperStep<A, T, P, H>,
    EventStep<A, T, P, H>,
    MarshalStep<P, H> {
        private static final Map<String, String> NO_ATTRS = new HashMap<String, String>();
        private String headerName;
        private H mediaType;
        private EnvelopeMarshaller<A, T, P> marshaller;
        private ExtensionFormatAccessor<A, T> extensionAccessor;
        private ExtensionMarshaller extensionMarshaller;
        private FormatHeaderMapper<H> headerMapper;
        private Supplier<CloudEvent<A, T>> event;

        private Builder() {
        }

        @Override
        public EnvelopeMarshallerStep<A, T, P, H> mime(String headerName, H mediaType) {
            Objects.requireNonNull(headerName);
            Objects.requireNonNull(mediaType);
            this.headerName = headerName;
            this.mediaType = mediaType;
            return this;
        }

        @Override
        public ExtensionAccessorStep<A, T, P, H> map(EnvelopeMarshaller<A, T, P> marshaller) {
            Objects.requireNonNull(marshaller);
            this.marshaller = marshaller;
            return this;
        }

        @Override
        public EventStep<A, T, P, H> skip() {
            return this;
        }

        @Override
        public ExtensionMarshallerStep<A, T, P, H> map(ExtensionFormatAccessor<A, T> accessor2) {
            Objects.requireNonNull(accessor2);
            this.extensionAccessor = accessor2;
            return this;
        }

        @Override
        public HeaderMapperStep<A, T, P, H> map(ExtensionMarshaller marshaller) {
            Objects.requireNonNull(marshaller);
            this.extensionMarshaller = marshaller;
            return this;
        }

        @Override
        public EventStep<A, T, P, H> map(FormatHeaderMapper<H> mapper) {
            Objects.requireNonNull(mapper);
            this.headerMapper = mapper;
            return this;
        }

        @Override
        public MarshalStep<P, H> withEvent(Supplier<CloudEvent<A, T>> event) {
            Objects.requireNonNull(event);
            this.event = event;
            return this;
        }

        @Override
        public Wire<P, String, H> marshal() {
            CloudEvent ce = this.event.get();
            P payload = this.marshaller.marshal(ce);
            Map headers = Optional.ofNullable(this.extensionAccessor).map((? super T accessor2) -> accessor2.extensionsOf(ce)).map((? super T extensions) -> this.extensionMarshaller.marshal((Collection<ExtensionFormat>)extensions)).map((? super T extensions) -> this.headerMapper.map(NO_ATTRS, (Map<String, String>)extensions)).orElse(new HashMap());
            headers.put(this.headerName, this.mediaType);
            return new Wire(payload, headers);
        }
    }

    public static interface HeaderMapperStep<A extends Attributes, T, P, H> {
        public EventStep<A, T, P, H> map(FormatHeaderMapper<H> var1);
    }

    public static interface ExtensionMarshallerStep<A extends Attributes, T, P, H> {
        public HeaderMapperStep<A, T, P, H> map(ExtensionMarshaller var1);
    }

    public static interface ExtensionAccessorStep<A extends Attributes, T, P, H> {
        public EventStep<A, T, P, H> skip();

        public ExtensionMarshallerStep<A, T, P, H> map(ExtensionFormatAccessor<A, T> var1);
    }

    public static interface EnvelopeMarshallerStep<A extends Attributes, T, P, H> {
        public ExtensionAccessorStep<A, T, P, H> map(EnvelopeMarshaller<A, T, P> var1);
    }

    public static interface MediaTypeStep<A extends Attributes, T, P, H> {
        public EnvelopeMarshallerStep<A, T, P, H> mime(String var1, H var2);
    }
}

