/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.common;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.interfaces.BCryptPassword;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.util.ModularCrypt;

public class BcryptUtil {
    private static final SecureRandom random = new SecureRandom();
    private static final WildFlyElytronPasswordProvider provider = new WildFlyElytronPasswordProvider();

    public static String bcryptHash(String password) {
        return BcryptUtil.bcryptHash(password, 10);
    }

    public static String bcryptHash(String password, int iterationCount) {
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return BcryptUtil.bcryptHash(password, iterationCount, salt);
    }

    public static String bcryptHash(String password, int iterationCount, byte[] salt) {
        PasswordFactory passwordFactory;
        if (iterationCount <= 0) {
            throw new IllegalArgumentException("Iteration count must be greater than zero");
        }
        Objects.requireNonNull(password, "password is required");
        Objects.requireNonNull(salt, "salt is required");
        if (salt.length != 16) {
            throw new IllegalArgumentException("Salt length must be exactly 16 bytes");
        }
        try {
            passwordFactory = PasswordFactory.getInstance("bcrypt", provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        IteratedSaltedPasswordAlgorithmSpec iteratedAlgorithmSpec = new IteratedSaltedPasswordAlgorithmSpec(iterationCount, salt);
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(password.toCharArray(), iteratedAlgorithmSpec);
        try {
            BCryptPassword original = (BCryptPassword)passwordFactory.generatePassword(encryptableSpec);
            return ModularCrypt.encodeAsString(original);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }
}

