/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.converters.uni.BuiltinConverters;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class UniConvert<T> {
    private final Uni<T> upstream;

    public UniConvert(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public <R> R with(Function<Uni<T>, R> converter) {
        ParameterValidation.nonNull(converter, "converter");
        return converter.apply(this.upstream);
    }

    public CompletionStage<T> toCompletionStage() {
        return (CompletionStage)this.with(BuiltinConverters.toCompletionStage());
    }

    public CompletableFuture<T> toCompletableFuture() {
        return (CompletableFuture)this.with(BuiltinConverters.toCompletableFuture());
    }

    public Publisher<T> toPublisher() {
        return (Publisher)this.with(BuiltinConverters.toPublisher());
    }
}

