/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.connectors.WorkerPoolRegistry;
import io.smallrye.reactive.messaging.helpers.BroadcastHelper;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.i18n.ProviderMessages;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.enterprise.inject.Instance;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;

public abstract class AbstractMediator {
    protected final MediatorConfiguration configuration;
    protected WorkerPoolRegistry workerPoolRegistry;
    private Invoker invoker;
    private Instance<PublisherDecorator> decorators;

    public AbstractMediator(MediatorConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void setDecorators(Instance<PublisherDecorator> decorators) {
        this.decorators = decorators;
    }

    public void setWorkerPoolRegistry(WorkerPoolRegistry workerPoolRegistry) {
        this.workerPoolRegistry = workerPoolRegistry;
    }

    public void run() {
    }

    public void connectToUpstream(PublisherBuilder<? extends Message<?>> publisher) {
    }

    public MediatorConfiguration configuration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object bean) {
        AbstractMediator abstractMediator = this;
        synchronized (abstractMediator) {
            if (this.invoker == null) {
                this.invoker = args -> {
                    try {
                        return this.configuration.getMethod().invoke(bean, args);
                    }
                    catch (Exception e) {
                        throw ProviderExceptions.ex.processingException(this.configuration.methodAsString(), e);
                    }
                };
            }
        }
    }

    protected <T> T invoke(Object ... args) {
        try {
            Objects.requireNonNull(this.invoker, ProviderMessages.msg.invokerNotInitialized());
            return (T)this.invoker.invoke(args);
        }
        catch (RuntimeException e) {
            ProviderLogging.log.methodException(this.configuration().methodAsString(), e);
            throw e;
        }
    }

    protected <T> Uni<T> invokeBlocking(Object ... args) {
        try {
            Objects.requireNonNull(this.invoker, ProviderMessages.msg.invokerNotInitialized());
            Objects.requireNonNull(this.workerPoolRegistry, ProviderMessages.msg.workerPoolNotInitialized());
            return this.workerPoolRegistry.executeWork(future -> future.complete(this.invoker.invoke(args)), this.configuration.getWorkerPoolName(), this.configuration.isBlockingExecutionOrdered());
        }
        catch (RuntimeException e) {
            ProviderLogging.log.methodException(this.configuration().methodAsString(), e);
            throw e;
        }
    }

    protected CompletionStage<Message<?>> getAckOrCompletion(Message<?> message) {
        CompletionStage<Void> ack = message.ack();
        if (ack != null) {
            return ack.thenApply(x -> message);
        }
        return CompletableFuture.completedFuture(message);
    }

    public PublisherBuilder<? extends Message<?>> getStream() {
        return null;
    }

    public MediatorConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getMethodAsString() {
        return this.configuration.methodAsString();
    }

    public SubscriberBuilder<Message<?>, Void> getComputedSubscriber() {
        return null;
    }

    public abstract boolean isConnected();

    protected Function<Message<?>, ? extends CompletionStage<? extends Message<?>>> managePreProcessingAck() {
        return this::handlePreProcessingAck;
    }

    protected CompletionStage<Message<?>> handlePreProcessingAck(Message<?> message) {
        if (this.configuration.getAcknowledgment() == Acknowledgment.Strategy.PRE_PROCESSING) {
            return this.getAckOrCompletion(message);
        }
        return CompletableFuture.completedFuture(message);
    }

    public PublisherBuilder<? extends Message<?>> decorate(PublisherBuilder<? extends Message<?>> input) {
        if (input == null) {
            return null;
        }
        for (PublisherDecorator decorator : this.decorators) {
            input = decorator.decorate(input, this.getConfiguration().getOutgoing());
        }
        if (this.configuration.getBroadcast()) {
            return BroadcastHelper.broadcastPublisher(input.buildRs(), this.configuration.getNumberOfSubscriberBeforeConnecting());
        }
        return input;
    }
}

