/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.vertx.core.json.JsonObject;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class JsonHelper {
    public static JsonObject asJsonObject(Config config) {
        JsonObject json = new JsonObject();
        Iterable<String> propertyNames = config.getPropertyNames();
        for (String key : propertyNames) {
            try {
                Optional<Integer> i = config.getOptionalValue(key, Integer.class);
                if (i.isPresent()) {
                    json.put(key, i.get());
                    continue;
                }
            }
            catch (ClassCastException | IllegalArgumentException i) {
                // empty catch block
            }
            try {
                Optional<Double> d = config.getOptionalValue(key, Double.class);
                if (d.isPresent()) {
                    json.put(key, d.get());
                    continue;
                }
            }
            catch (ClassCastException | IllegalArgumentException d) {
                // empty catch block
            }
            try {
                String value = config.getOptionalValue(key, String.class).orElse("").trim();
                if (value.equalsIgnoreCase("false")) {
                    json.put(key, false);
                    continue;
                }
                if (value.equalsIgnoreCase("true")) {
                    json.put(key, true);
                    continue;
                }
                json.put(key, value);
            }
            catch (ClassCastException classCastException) {}
        }
        return json;
    }
}

