/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.resteasy.annotations.providers.jaxb.JAXBConfig;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.LogMessages;
import org.jboss.resteasy.plugins.providers.jaxb.i18n.Messages;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JAXBContextWrapper
extends JAXBContext {
    private static final String NAMESPACE_PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
    private static Constructor mapperConstructor = null;
    private final JAXBContext wrappedContext;
    private final ThreadLocal<Unmarshaller> unmarshaller = new ThreadLocal();
    private Object mapper;
    private Schema schema;

    public JAXBContextWrapper(JAXBContext wrappedContext, JAXBConfig config) throws JAXBException {
        this.processConfig(config);
        this.wrappedContext = wrappedContext;
    }

    public JAXBContextWrapper(final Class<?>[] classes, final Map<String, Object> properties, JAXBConfig config) throws JAXBException {
        this.processConfig(config);
        try {
            this.wrappedContext = System.getSecurityManager() == null ? JAXBContext.newInstance(classes, properties) : AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                @Override
                public JAXBContext run() throws JAXBException {
                    return JAXBContext.newInstance(classes, properties);
                }
            });
        }
        catch (PrivilegedActionException paex) {
            throw new JAXBException(paex.getMessage());
        }
    }

    public JAXBContextWrapper(final String contextPath, JAXBConfig config) throws JAXBException {
        this.processConfig(config);
        try {
            this.wrappedContext = System.getSecurityManager() == null ? JAXBContext.newInstance(contextPath) : AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                @Override
                public JAXBContext run() throws JAXBException {
                    return JAXBContext.newInstance(contextPath);
                }
            });
        }
        catch (PrivilegedActionException paex) {
            throw new JAXBException(paex.getMessage());
        }
    }

    public JAXBContextWrapper(JAXBConfig config, Class<?> ... classes) throws JAXBException {
        this(classes, Collections.emptyMap(), config);
    }

    private void processConfig(JAXBConfig config) throws JAXBException {
        if (config != null) {
            if (config.useNameSpacePrefix()) {
                if (mapperConstructor == null) {
                    throw new JAXBException(Messages.MESSAGES.namespacePrefixMapperNotInClassPath());
                }
                try {
                    this.mapper = mapperConstructor.newInstance(config.namespaces());
                }
                catch (Exception e) {
                    throw new JAXBException(e);
                }
            }
            if (!"".equals(config.schema())) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance(config.schemaType());
                try {
                    InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(config.schema());
                    this.schema = schemaFactory.newSchema(new StreamSource(in));
                }
                catch (SAXException e) {
                    throw new JAXBException(Messages.MESSAGES.errorTryingToLoadSchema(config.schema()), e);
                }
            }
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Binder<Node> createBinder() {
        return this.wrappedContext.createBinder();
    }

    @Override
    public <T> Binder<T> createBinder(Class<T> domType) {
        return this.wrappedContext.createBinder(domType);
    }

    @Override
    public JAXBIntrospector createJAXBIntrospector() {
        return this.wrappedContext.createJAXBIntrospector();
    }

    @Override
    public Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.wrappedContext.createMarshaller();
        if (this.mapper != null) {
            try {
                marshaller.setProperty(NAMESPACE_PREFIX_MAPPER, this.mapper);
            }
            catch (PropertyException e) {
                LogMessages.LOGGER.warn(e.getMessage());
            }
        }
        return marshaller;
    }

    @Override
    public Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller u = this.unmarshaller.get();
        if (u == null) {
            u = this.wrappedContext.createUnmarshaller();
            this.unmarshaller.set(u);
        }
        return u;
    }

    @Override
    public Validator createValidator() throws JAXBException {
        return this.wrappedContext.createValidator();
    }

    @Override
    public void generateSchema(SchemaOutputResolver outputResolver) throws IOException {
        this.wrappedContext.generateSchema(outputResolver);
    }

    static {
        try {
            final Class[] namespace = new Class[1];
            final Class[] mapper = new Class[1];
            if (System.getSecurityManager() == null) {
                namespace[0] = JAXBContextWrapper.class.getClassLoader().loadClass("com.sun.xml.bind.marshaller.NamespacePrefixMapper");
                mapper[0] = JAXBContextWrapper.class.getClassLoader().loadClass("org.jboss.resteasy.plugins.providers.jaxb.XmlNamespacePrefixMapper");
            } else {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        namespace[0] = JAXBContextWrapper.class.getClassLoader().loadClass("com.sun.xml.bind.marshaller.NamespacePrefixMapper");
                        mapper[0] = JAXBContextWrapper.class.getClassLoader().loadClass("org.jboss.resteasy.plugins.providers.jaxb.XmlNamespacePrefixMapper");
                        return null;
                    }
                });
            }
            mapperConstructor = mapper[0].getConstructors()[0];
        }
        catch (ClassNotFoundException | PrivilegedActionException exception) {
            // empty catch block
        }
    }
}

