/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan.cache;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.RemoteCache;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.infinispan.listener.CacheObjectCreatedListener;
import org.kie.kogito.persistence.infinispan.listener.CacheObjectRemovedListener;
import org.kie.kogito.persistence.infinispan.listener.CacheObjectUpdatedListener;
import org.kie.kogito.persistence.infinispan.query.InfinispanQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageImpl<K, V>
implements Storage<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageImpl.class);
    private RemoteCache<K, V> delegate;
    private String rootType;

    public StorageImpl(RemoteCache<K, V> delegate, String rootType) {
        this.delegate = delegate;
        this.rootType = rootType;
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public void addObjectCreatedListener(Consumer<V> consumer) {
        LOGGER.debug("Adding new object created listener into Cache: {}", (Object)this.delegate.getName());
        this.delegate.addClientListener(new CacheObjectCreatedListener<K, V>(this.delegate, consumer));
    }

    @Override
    public void addObjectUpdatedListener(Consumer<V> consumer) {
        LOGGER.debug("Adding new object updated listener into Cache: {}", (Object)this.delegate.getName());
        this.delegate.addClientListener(new CacheObjectUpdatedListener<K, V>(this.delegate, consumer));
    }

    @Override
    public void addObjectRemovedListener(Consumer<K> consumer) {
        LOGGER.debug("Adding new object removed listener into Cache: {}", (Object)this.delegate.getName());
        this.delegate.addClientListener(new CacheObjectRemovedListener<K>(consumer));
    }

    public RemoteCache<K, V> getDelegate() {
        return this.delegate;
    }

    @Override
    public String getRootType() {
        return this.rootType;
    }

    @Override
    public Query<V> query() {
        return new InfinispanQuery<V>(this.delegate, this.rootType);
    }
}

