/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudevents.v1.AttributesImpl;
import io.cloudevents.v1.CloudEventImpl;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.kie.kogito.tracing.decision.event.trace.TraceEventType;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.messaging.BaseEventConsumer;
import org.kie.kogito.trusty.service.messaging.incoming.TraceEventConverter;

@ApplicationScoped
public class TraceEventConsumer
extends BaseEventConsumer<TraceEvent> {
    private static final TypeReference<CloudEventImpl<TraceEvent>> CLOUD_EVENT_TYPE_REF = new TypeReference<CloudEventImpl<TraceEvent>>(){};

    TraceEventConsumer() {
    }

    @Inject
    public TraceEventConsumer(TrustyService service) {
        super(service);
    }

    @Override
    @Incoming(value="kogito-tracing-decision")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        return super.handleMessage(message);
    }

    @Override
    protected TypeReference<CloudEventImpl<TraceEvent>> getCloudEventType() {
        return CLOUD_EVENT_TYPE_REF;
    }

    @Override
    protected void handleCloudEvent(CloudEventImpl<TraceEvent> cloudEvent) {
        AttributesImpl attributes = cloudEvent.getAttributes();
        Optional<TraceEvent> optData = cloudEvent.getData();
        if (!optData.isPresent()) {
            LOG.error("Received CloudEvent with id {} from {} with empty data", (Object)attributes.getId(), (Object)attributes.getSource());
            return;
        }
        LOG.debug("Received CloudEvent with id {} from {}", (Object)attributes.getId(), (Object)attributes.getSource());
        TraceEvent traceEvent = optData.get();
        TraceEventType traceEventType = traceEvent.getHeader().getType();
        if (traceEventType == TraceEventType.DMN) {
            this.service.processDecision(attributes.getId(), TraceEventConverter.toDecision(traceEvent));
        } else {
            LOG.error("Unsupported TraceEvent type {}", (Object)traceEventType);
        }
    }
}

