/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.outgoing;

import io.reactivex.BackpressureStrategy;
import io.reactivex.subjects.PublishSubject;
import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.kie.kogito.explainability.api.ExplainabilityRequestDto;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExplainabilityRequestProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplainabilityRequestProducer.class);
    private static final URI URI_PRODUCER = URI.create("trustyService/ExplainabilityRequestProducer");
    private final PublishSubject<String> eventSubject = PublishSubject.create();

    public void sendEvent(ExplainabilityRequestDto request) {
        LOGGER.info("Sending explainability request with id {}", (Object)request.getExecutionId());
        String payload = CloudEventUtils.encode(CloudEventUtils.build(request.getExecutionId(), URI_PRODUCER, request, ExplainabilityRequestDto.class));
        this.eventSubject.onNext(payload);
    }

    @Outgoing(value="trusty-explainability-request")
    public Publisher<String> getEventPublisher() {
        return this.eventSubject.toFlowable(BackpressureStrategy.BUFFER);
    }
}

