/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.trusty.service.responses.MessageResponse;
import org.kie.kogito.trusty.service.responses.TypedValueResponse;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;

public class DecisionOutcomeResponse {
    @JsonProperty(value="outcomeId")
    private String outcomeId;
    @JsonProperty(value="outcomeName")
    private String outcomeName;
    @JsonProperty(value="evaluationStatus")
    private String evaluationStatus;
    @JsonProperty(value="outcomeResult")
    private TypedValueResponse outcomeResult;
    @JsonProperty(value="outcomeInputs")
    private Collection<TypedValueResponse> outcomeInputs;
    @JsonProperty(value="messages")
    private Collection<MessageResponse> messages;
    @JsonProperty(value="hasErrors")
    private boolean hasErrors;

    private DecisionOutcomeResponse() {
    }

    public DecisionOutcomeResponse(String outcomeId, String outcomeName, String evaluationStatus, TypedValueResponse outcomeResult, Collection<TypedValueResponse> outcomeInputs, Collection<MessageResponse> messages, boolean hasErrors) {
        this.outcomeId = outcomeId;
        this.outcomeName = outcomeName;
        this.evaluationStatus = evaluationStatus;
        this.outcomeResult = outcomeResult;
        this.outcomeInputs = outcomeInputs;
        this.messages = messages;
        this.hasErrors = hasErrors;
    }

    public static DecisionOutcomeResponse from(DecisionOutcome outcome) {
        return outcome == null ? null : new DecisionOutcomeResponse(outcome.getOutcomeId(), outcome.getOutcomeName(), outcome.getEvaluationStatus(), TypedValueResponse.from(outcome.getOutcomeResult()), DecisionOutcomeResponse.from(outcome.getOutcomeInputs(), TypedValueResponse::from), DecisionOutcomeResponse.from(outcome.getMessages(), MessageResponse::from), outcome.hasErrors());
    }

    public static <T, U> Collection<U> from(Collection<T> input, Function<T, U> mapper) {
        return input == null ? null : (Collection)input.stream().map(mapper).collect(Collectors.toList());
    }

    public String getOutcomeId() {
        return this.outcomeId;
    }

    public String getOutcomeName() {
        return this.outcomeName;
    }

    public String getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public TypedValueResponse getOutcomeResult() {
        return this.outcomeResult;
    }

    public Collection<TypedValueResponse> getOutcomeInputs() {
        return this.outcomeInputs;
    }

    public Collection<MessageResponse> getMessages() {
        return this.messages;
    }

    public boolean isHasErrors() {
        return this.hasErrors;
    }
}

