/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service;

import java.time.OffsetDateTime;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.TrustyServiceImpl;
import org.kie.kogito.trusty.service.mocks.StorageImplMock;
import org.kie.kogito.trusty.storage.api.TrustyStorageService;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.Execution;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TrustyServiceTest {
    private TrustyStorageService trustyStorageServiceMock;
    private TrustyService trustyService;

    @BeforeEach
    void setup() {
        this.trustyStorageServiceMock = (TrustyStorageService)Mockito.mock(TrustyStorageService.class);
        this.trustyService = new TrustyServiceImpl(this.trustyStorageServiceMock);
    }

    @Test
    void givenADecisionWhenStoreDecisionIsCalledThenNoExceptionsAreThrown() {
        Decision decision = new Decision();
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.put(ArgumentMatchers.any(Object.class), ArgumentMatchers.any(Object.class))).thenReturn((Object)decision);
        Mockito.when((Object)this.trustyStorageServiceMock.getDecisionsStorage()).thenReturn((Object)storageMock);
        Assertions.assertDoesNotThrow(() -> this.trustyService.storeDecision("test", decision));
    }

    @Test
    void givenADecisionWhenADecisionIsStoredAndRetrievedThenTheOriginalObjectIsReturned() {
        String executionId = "executionId";
        Decision decision = new Decision();
        decision.setExecutionId(executionId);
        Query queryMock = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)queryMock.filter((List)ArgumentMatchers.any(List.class))).thenReturn((Object)queryMock);
        Mockito.when((Object)queryMock.limit((Integer)ArgumentMatchers.any(Integer.class))).thenReturn((Object)queryMock);
        Mockito.when((Object)queryMock.offset((Integer)ArgumentMatchers.any(Integer.class))).thenReturn((Object)queryMock);
        Mockito.when((Object)queryMock.execute()).thenReturn(List.of(decision));
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.put(ArgumentMatchers.eq((Object)executionId), ArgumentMatchers.any(Object.class))).thenReturn((Object)decision);
        Mockito.when((Object)storageMock.containsKey(ArgumentMatchers.eq((Object)executionId))).thenReturn((Object)false);
        Mockito.when((Object)storageMock.query()).thenReturn((Object)queryMock);
        Mockito.when((Object)this.trustyStorageServiceMock.getDecisionsStorage()).thenReturn((Object)storageMock);
        this.trustyService.storeDecision("executionId", decision);
        List result = this.trustyService.getExecutionHeaders(OffsetDateTime.now().minusDays(1L), OffsetDateTime.now(), 100, 0, "");
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)decision.getExecutionId(), (Object)((Execution)result.get(0)).getExecutionId());
    }

    @Test
    void givenADecisionWhenADecisionIsStoredAndRetrievedByIdThenTheOriginalObjectIsReturned() {
        String executionId = "executionId";
        Decision decision = new Decision();
        decision.setExecutionId(executionId);
        StorageImplMock storageMock = new StorageImplMock(Decision.class);
        Mockito.when((Object)this.trustyStorageServiceMock.getDecisionsStorage()).thenReturn(storageMock);
        this.trustyService.storeDecision(executionId, decision);
        Decision result = this.trustyService.getDecisionById(executionId);
        Assertions.assertEquals((Object)executionId, (Object)result.getExecutionId());
    }

    @Test
    void givenAModelWhenStoreModelIsCalledThenNoExceptionsAreThrown() {
        String model = "definition";
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.put(ArgumentMatchers.any(Object.class), ArgumentMatchers.any(Object.class))).thenReturn((Object)model);
        Mockito.when((Object)this.trustyStorageServiceMock.getModelStorage()).thenReturn((Object)storageMock);
        Assertions.assertDoesNotThrow(() -> this.trustyService.storeModel("groupId", "artifactId", "version", "name", "namespace", model));
    }

    @Test
    void givenAModelWhenStoreModelIsCalledMoreThanOnceForSameModelThenExceptionIsThrown() {
        String modelId = "name:namespace";
        String model = "definition";
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.containsKey((Object)modelId)).thenReturn((Object)true);
        Mockito.when((Object)storageMock.put(ArgumentMatchers.any(Object.class), ArgumentMatchers.any(Object.class))).thenReturn((Object)model);
        Mockito.when((Object)this.trustyStorageServiceMock.getModelStorage()).thenReturn((Object)storageMock);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.trustyService.storeModel("groupId", "artifactId", "version", "name", "namespace", model));
    }

    @Test
    void givenAModelWhenAModelIsStoredAndRetrievedByIdThenTheOriginalObjectIsReturned() {
        String modelId = "name:namespace";
        String model = "definition";
        StorageImplMock storageMock = new StorageImplMock(String.class);
        Mockito.when((Object)this.trustyStorageServiceMock.getModelStorage()).thenReturn(storageMock);
        this.trustyService.storeModel("groupId", "artifactId", "version", "name", "namespace", model);
        String result = this.trustyService.getModelById(modelId);
        Assertions.assertEquals((Object)model, (Object)result);
    }

    @Test
    void whenAModelIsNotStoredAndRetrievedByIdThenExceptionIsThrown() {
        String modelId = "name:namespace";
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.containsKey((Object)modelId)).thenReturn((Object)false);
        Mockito.when((Object)this.trustyStorageServiceMock.getModelStorage()).thenReturn((Object)storageMock);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.trustyService.getModelById(modelId));
    }
}

