/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.filter.log.ResponseLoggingFilter;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.tracing.decision.event.common.MessageLevel;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.responses.DecisionOutcomeResponse;
import org.kie.kogito.trusty.service.responses.DecisionOutcomesResponse;
import org.kie.kogito.trusty.service.responses.DecisionStructuredInputsResponse;
import org.kie.kogito.trusty.service.responses.ExecutionHeaderResponse;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.ExecutionTypeEnum;
import org.kie.kogito.trusty.storage.api.model.Message;
import org.kie.kogito.trusty.storage.api.model.MessageExceptionField;
import org.kie.kogito.trusty.storage.api.model.TypedValue;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@QuarkusTest
public class DecisionsApiV1IT {
    private static final String TEST_EXECUTION_ID = "executionId";
    private static final String TEST_OUTCOME_ID = "FirstOutcome";
    @InjectMock
    TrustyService executionService;

    @Test
    void testGetExecutionById() throws Exception {
        this.assertGetExecutionByIdCorrectResponse(ListStatus.FULL, ListStatus.FULL);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.FULL, ListStatus.EMPTY);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.FULL, ListStatus.NULL);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.EMPTY, ListStatus.FULL);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.EMPTY, ListStatus.EMPTY);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.EMPTY, ListStatus.NULL);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.NULL, ListStatus.FULL);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.NULL, ListStatus.EMPTY);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.NULL, ListStatus.NULL);
        this.assertBadRequestWithoutDecision("");
    }

    @Test
    void testGetStructuredInputs() throws Exception {
        this.assertGetStructuredInputsCorrectFullResponse(ListStatus.FULL, ListStatus.FULL);
        this.assertGetStructuredInputsCorrectFullResponse(ListStatus.FULL, ListStatus.EMPTY);
        this.assertGetStructuredInputsCorrectFullResponse(ListStatus.FULL, ListStatus.NULL);
        this.assertGetStructuredInputsCorrectEmptyResponse(ListStatus.EMPTY, ListStatus.FULL);
        this.assertGetStructuredInputsCorrectEmptyResponse(ListStatus.EMPTY, ListStatus.EMPTY);
        this.assertGetStructuredInputsCorrectEmptyResponse(ListStatus.EMPTY, ListStatus.NULL);
        this.assertBadRequestWithDecision("/structuredInputs", ListStatus.NULL, ListStatus.FULL);
        this.assertBadRequestWithDecision("/structuredInputs", ListStatus.NULL, ListStatus.EMPTY);
        this.assertBadRequestWithDecision("/structuredInputs", ListStatus.NULL, ListStatus.NULL);
        this.assertBadRequestWithoutDecision("/structuredInputs");
    }

    @Test
    void testGetOutcomes() throws Exception {
        this.assertGetOutcomesCorrectFullResponse(ListStatus.FULL, ListStatus.FULL);
        this.assertGetOutcomesCorrectEmptyResponse(ListStatus.FULL, ListStatus.EMPTY);
        this.assertGetOutcomesCorrectNullResponse(ListStatus.FULL, ListStatus.NULL);
        this.assertGetOutcomesCorrectFullResponse(ListStatus.EMPTY, ListStatus.FULL);
        this.assertGetOutcomesCorrectEmptyResponse(ListStatus.EMPTY, ListStatus.EMPTY);
        this.assertGetOutcomesCorrectNullResponse(ListStatus.EMPTY, ListStatus.NULL);
        this.assertGetOutcomesCorrectFullResponse(ListStatus.NULL, ListStatus.FULL);
        this.assertGetOutcomesCorrectEmptyResponse(ListStatus.NULL, ListStatus.EMPTY);
        this.assertGetOutcomesCorrectNullResponse(ListStatus.NULL, ListStatus.NULL);
        this.assertBadRequestWithoutDecision("/structuredInputs");
    }

    @Test
    void testGetOutcomeById() throws Exception {
        this.assertGetOutcomeByIdCorrectResponse(ListStatus.FULL, ListStatus.FULL);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.FULL, ListStatus.EMPTY);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.FULL, ListStatus.NULL);
        this.assertGetOutcomeByIdCorrectResponse(ListStatus.EMPTY, ListStatus.FULL);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.EMPTY, ListStatus.EMPTY);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.EMPTY, ListStatus.NULL);
        this.assertGetOutcomeByIdCorrectResponse(ListStatus.NULL, ListStatus.FULL);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.NULL, ListStatus.EMPTY);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.NULL, ListStatus.NULL);
        this.assertBadRequestWithoutDecision("/structuredInputs");
    }

    private void assertBadRequestWithDecision(String path, ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, outcomesStatus);
        ((ValidatableResponse)this.get(path).then()).statusCode(400);
    }

    private void assertBadRequestWithoutDecision(String path) {
        this.mockServiceWithoutDecision();
        ((ValidatableResponse)this.get(path).then()).statusCode(400);
    }

    private void assertGetExecutionByIdCorrectResponse(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, outcomesStatus);
        ExecutionHeaderResponse response = (ExecutionHeaderResponse)this.get().as(ExecutionHeaderResponse.class);
        Assertions.assertEquals((Object)TEST_EXECUTION_ID, (Object)response.getExecutionId());
        Assertions.assertTrue((boolean)response.hasSucceeded());
    }

    private void assertGetOutcomeByIdCorrectResponse(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, outcomesStatus);
        DecisionOutcomeResponse response = (DecisionOutcomeResponse)this.get("/outcomes/FirstOutcome").as(DecisionOutcomeResponse.class);
        Assertions.assertEquals((Object)TEST_OUTCOME_ID, (Object)response.getOutcomeId());
    }

    private void assertGetOutcomesCorrectEmptyResponse(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, outcomesStatus);
        DecisionOutcomesResponse response = (DecisionOutcomesResponse)this.get("/outcomes").as(DecisionOutcomesResponse.class);
        Assertions.assertSame((Object)0, (Object)response.getOutcomes().size());
    }

    private void assertGetOutcomesCorrectFullResponse(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, outcomesStatus);
        DecisionOutcomesResponse response = (DecisionOutcomesResponse)this.get("/outcomes").as(DecisionOutcomesResponse.class);
        Assertions.assertSame((Object)1, (Object)response.getOutcomes().size());
        Assertions.assertTrue((boolean)response.getOutcomes().stream().anyMatch(o -> "ONE".equals(o.getOutcomeName())));
    }

    private void assertGetOutcomesCorrectNullResponse(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, outcomesStatus);
        DecisionOutcomesResponse response = (DecisionOutcomesResponse)this.get("/outcomes").as(DecisionOutcomesResponse.class);
        Assertions.assertNull((Object)response.getOutcomes());
    }

    private void assertGetStructuredInputsCorrectEmptyResponse(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, outcomesStatus);
        DecisionStructuredInputsResponse response = (DecisionStructuredInputsResponse)this.get("/structuredInputs").as(DecisionStructuredInputsResponse.class);
        Assertions.assertSame((Object)0, (Object)response.getInputs().size());
    }

    private void assertGetStructuredInputsCorrectFullResponse(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, outcomesStatus);
        DecisionStructuredInputsResponse response = (DecisionStructuredInputsResponse)this.get("/structuredInputs").as(DecisionStructuredInputsResponse.class);
        Assertions.assertSame((Object)2, (Object)response.getInputs().size());
        Assertions.assertTrue((boolean)response.getInputs().stream().anyMatch(i -> "first".equals(i.getName())));
        Assertions.assertTrue((boolean)response.getInputs().stream().anyMatch(i -> "second".equals(i.getName())));
    }

    private Decision buildValidDecision(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Decision decision = new Decision();
        decision.setExecutionId(TEST_EXECUTION_ID);
        decision.setExecutionTimestamp(Long.valueOf(1591692950000L));
        decision.setExecutionType(ExecutionTypeEnum.DECISION);
        decision.setExecutedModelName("testModel");
        decision.setSuccess(Boolean.valueOf(true));
        switch (inputsStatus) {
            case EMPTY: {
                decision.setInputs(List.of());
                break;
            }
            case FULL: {
                decision.setInputs(List.of(new TypedValue("first", "FirstInput", mapper.readTree("\"Hello\"")), new TypedValue("second", "SecondInput", mapper.readTree("12345"))));
            }
        }
        switch (outcomesStatus) {
            case EMPTY: {
                decision.setOutcomes(List.of());
                break;
            }
            case FULL: {
                decision.setOutcomes(List.of(new DecisionOutcome(TEST_OUTCOME_ID, "ONE", "SUCCEEDED", new TypedValue("result", "ResType", mapper.readTree("\"The First Outcome\"")), List.of(), List.of(new Message(MessageLevel.WARNING, "INTERNAL", "TEST", "testSrc", "Test message", new MessageExceptionField("TestException", "Test exception message", new MessageExceptionField("TestExceptionCause", "Test exception cause message", null)))))));
            }
        }
        return decision;
    }

    private Response get() {
        return this.get("");
    }

    private Response get(String endpoint) {
        return (Response)RestAssured.given().filter((Filter)new ResponseLoggingFilter()).contentType(ContentType.JSON).when().get("/v1/executions/decisions/executionId" + endpoint, new Object[0]);
    }

    private void mockServiceWithDecision(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        Mockito.when((Object)this.executionService.getDecisionById((String)ArgumentMatchers.eq((Object)TEST_EXECUTION_ID))).thenReturn((Object)this.buildValidDecision(inputsStatus, outcomesStatus));
    }

    private void mockServiceWithoutDecision() {
        Mockito.when((Object)this.executionService.getDecisionById(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new IllegalArgumentException("Execution does not exist.")});
    }

    private static enum ListStatus {
        FULL,
        EMPTY,
        NULL;

    }
}

