/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import io.cloudevents.v1.CloudEventImpl;
import java.net.URI;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.ExplainabilityResultDto;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.messaging.incoming.ExplainabilityResultConsumer;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityResult;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ExplainabilityResultConsumerTest {
    private TrustyService trustyService;
    private ExplainabilityResultConsumer consumer;

    @BeforeEach
    void setup() {
        this.trustyService = (TrustyService)Mockito.mock(TrustyService.class);
        this.consumer = new ExplainabilityResultConsumer(this.trustyService);
    }

    @Test
    void testCorrectCloudEvent() {
        Message<String> message = this.mockMessage(ExplainabilityResultConsumerTest.buildCloudEventJsonString(new ExplainabilityResultDto("test")));
        ((TrustyService)Mockito.doNothing().when((Object)this.trustyService)).storeExplainability((String)ArgumentMatchers.any(String.class), (ExplainabilityResult)ArgumentMatchers.any(ExplainabilityResult.class));
        this.testNumberOfInvocations(message, 1);
    }

    @Test
    void testInvalidPayload() {
        Message<String> message = this.mockMessage("Not a cloud event");
        this.testNumberOfInvocations(message, 0);
    }

    @Test
    void testExceptionsAreCatched() {
        Message<String> message = this.mockMessage(ExplainabilityResultConsumerTest.buildCloudEventJsonString(new ExplainabilityResultDto("test")));
        ((TrustyService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Something really bad")}).when((Object)this.trustyService)).storeExplainability((String)ArgumentMatchers.any(String.class), (ExplainabilityResult)ArgumentMatchers.any(ExplainabilityResult.class));
        Assertions.assertDoesNotThrow(() -> this.consumer.handleMessage(message));
    }

    private Message<String> mockMessage(String payload) {
        Message message = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((String)message.getPayload())).thenReturn((Object)payload);
        return message;
    }

    private void testNumberOfInvocations(Message<String> message, int wantedNumberOfServiceInvocations) {
        this.consumer.handleMessage(message);
        ((TrustyService)Mockito.verify((Object)this.trustyService, (VerificationMode)Mockito.times((int)wantedNumberOfServiceInvocations))).storeExplainability((String)ArgumentMatchers.any(), (ExplainabilityResult)ArgumentMatchers.any());
        ((Message)Mockito.verify(message, (VerificationMode)Mockito.times((int)1))).ack();
    }

    public static CloudEventImpl<ExplainabilityResultDto> buildExplainabilityCloudEvent(ExplainabilityResultDto resultDto) {
        return CloudEventUtils.build((String)resultDto.getExecutionId(), (URI)URI.create("explainabilityResult/test"), (Object)resultDto, ExplainabilityResultDto.class);
    }

    public static String buildCloudEventJsonString(ExplainabilityResultDto resultDto) {
        return CloudEventUtils.encode(ExplainabilityResultConsumerTest.buildExplainabilityCloudEvent(resultDto));
    }
}

