/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.testcontainers.quarkus.InfinispanQuarkusTestResource;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.TrustyServiceTestUtils;
import org.kie.kogito.trusty.storage.api.TrustyStorageService;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=InfinispanQuarkusTestResource.class), @QuarkusTestResource(value=KafkaQuarkusTestResource.class)})
class ModelEventConsumerInfinispanIT {
    @ConfigProperty(name="kafka.bootstrap.servers")
    private String kafkaBootstrapServers;
    @Inject
    TrustyService trustyService;
    @Inject
    TrustyStorageService trustyStorageService;
    KafkaClient kafkaClient;

    ModelEventConsumerInfinispanIT() {
    }

    @BeforeEach
    public void setup() {
        this.trustyStorageService.getModelStorage().clear();
    }

    @Test
    void testCorrectCloudEvent() {
        this.kafkaClient = new KafkaClient(this.kafkaBootstrapServers);
        this.kafkaClient.produce(TrustyServiceTestUtils.buildCloudEventJsonString(TrustyServiceTestUtils.buildCorrectModelEvent()), "kogito-tracing-model-test");
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertDoesNotThrow(() -> this.trustyService.getModelById("name:namespace")));
        String storedDefinition = this.trustyService.getModelById("name:namespace");
        Assertions.assertNotNull((Object)storedDefinition);
        Assertions.assertEquals((Object)"definition", (Object)storedDefinition);
    }
}

