/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import org.eclipse.microprofile.reactive.messaging.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.TrustyServiceTestUtils;
import org.kie.kogito.trusty.service.messaging.incoming.ModelEventConsumer;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ModelEventConsumerTest {
    private TrustyService trustyService;
    private ModelEventConsumer consumer;

    ModelEventConsumerTest() {
    }

    @BeforeEach
    void setup() {
        this.trustyService = (TrustyService)Mockito.mock(TrustyService.class);
        this.consumer = new ModelEventConsumer(this.trustyService);
    }

    @Test
    void testCorrectCloudEvent() {
        Message<String> message = this.mockMessage(TrustyServiceTestUtils.buildCloudEventJsonString(TrustyServiceTestUtils.buildCorrectModelEvent()));
        this.testNumberOfInvocations(message, 1);
    }

    @Test
    void testCloudEventWithoutData() {
        Message<String> message = this.mockMessage(TrustyServiceTestUtils.buildCloudEventWithoutDataJsonString());
        this.testNumberOfInvocations(message, 0);
    }

    @Test
    void testGibberishPayload() {
        Message<String> message = this.mockMessage("DefinitelyNotASerializedCloudEvent123456");
        this.testNumberOfInvocations(message, 0);
    }

    @Test
    void testExceptionsAreCatched() {
        Message<String> message = this.mockMessage(TrustyServiceTestUtils.buildCloudEventJsonString(TrustyServiceTestUtils.buildCorrectTraceEvent("82639415-ceb1-411a-b3c8-4832e6a82905")));
        ((TrustyService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Something really bad")}).when((Object)this.trustyService)).storeDecision((String)ArgumentMatchers.any(String.class), (Decision)ArgumentMatchers.any(Decision.class));
        Assertions.assertDoesNotThrow(() -> this.consumer.handleMessage(message));
    }

    @Test
    void testUnsupportedExecutionTypesAreNotHandled() {
        Message<String> message = this.mockMessage(TrustyServiceTestUtils.buildCloudEventJsonString(TrustyServiceTestUtils.buildTraceEventWithNullType("test")));
        this.testNumberOfInvocations(message, 0);
    }

    private Message<String> mockMessage(String payload) {
        Message message = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((String)message.getPayload())).thenReturn((Object)payload);
        return message;
    }

    private void testNumberOfInvocations(Message<String> message, int wantedNumberOfServiceInvocations) {
        this.consumer.handleMessage(message);
        ((TrustyService)Mockito.verify((Object)this.trustyService, (VerificationMode)Mockito.times((int)wantedNumberOfServiceInvocations))).storeModel((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((Message)Mockito.verify(message, (VerificationMode)Mockito.times((int)1))).ack();
    }
}

