/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.testcontainers.quarkus.InfinispanQuarkusTestResource;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.TrustyServiceTestUtils;
import org.kie.kogito.trusty.service.messaging.incoming.TraceEventTestUtils;
import org.kie.kogito.trusty.storage.api.TrustyStorageService;
import org.kie.kogito.trusty.storage.api.model.Decision;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=InfinispanQuarkusTestResource.class), @QuarkusTestResource(value=KafkaQuarkusTestResource.class)})
class TraceEventConsumerInfinispanIT {
    @ConfigProperty(name="kafka.bootstrap.servers")
    String kafkaBootstrapServers;
    @Inject
    TrustyService trustyService;
    @Inject
    TrustyStorageService trustyStorageService;
    KafkaClient kafkaClient;

    TraceEventConsumerInfinispanIT() {
    }

    @BeforeEach
    public void setup() {
        this.trustyStorageService.getDecisionsStorage().clear();
        this.kafkaClient = new KafkaClient(this.kafkaBootstrapServers);
    }

    @Test
    void testCorrectCloudEvent() {
        this.kafkaClient.produce(TrustyServiceTestUtils.buildCloudEventJsonString(TrustyServiceTestUtils.buildCorrectTraceEvent("82639415-ceb1-411a-b3c8-4832e6a82905")), "kogito-tracing-test");
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertDoesNotThrow(() -> this.trustyService.getDecisionById("82639415-ceb1-411a-b3c8-4832e6a82905")));
        Decision storedDecision = this.trustyService.getDecisionById("82639415-ceb1-411a-b3c8-4832e6a82905");
        Assertions.assertNotNull((Object)storedDecision);
        TraceEventTestUtils.assertDecision(TrustyServiceTestUtils.buildCorrectDecision("82639415-ceb1-411a-b3c8-4832e6a82905"), storedDecision);
    }

    @Test
    void testCloudEventWithErrors() {
        this.kafkaClient.produce(TrustyServiceTestUtils.buildCloudEventJsonString(TrustyServiceTestUtils.buildTraceEventWithErrors()), "kogito-tracing-test");
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertDoesNotThrow(() -> this.trustyService.getDecisionById("6f8f5a8b-5477-464c-b5d3-1e3ed399e0da")));
        Decision storedDecision = this.trustyService.getDecisionById("6f8f5a8b-5477-464c-b5d3-1e3ed399e0da");
        Assertions.assertNotNull((Object)storedDecision);
        TraceEventTestUtils.assertDecision(TrustyServiceTestUtils.buildDecisionWithErrors(), storedDecision);
    }
}

