/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import org.junit.jupiter.api.Test;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.kie.kogito.trusty.service.TrustyServiceTestUtils;
import org.kie.kogito.trusty.service.messaging.incoming.TraceEventConverter;
import org.kie.kogito.trusty.service.messaging.incoming.TraceEventTestUtils;
import org.kie.kogito.trusty.storage.api.model.Decision;

class TraceEventConverterTest {
    TraceEventConverterTest() {
    }

    private static void doTest(TraceEvent traceEvent, Decision expectedDecision) {
        Decision actualDecision = TraceEventConverter.toDecision((TraceEvent)traceEvent);
        TraceEventTestUtils.assertDecision(expectedDecision, actualDecision);
    }

    @Test
    void testCorrectTraceEvent() {
        TraceEventConverterTest.doTest(TrustyServiceTestUtils.buildCorrectTraceEvent("82639415-ceb1-411a-b3c8-4832e6a82905"), TrustyServiceTestUtils.buildCorrectDecision("82639415-ceb1-411a-b3c8-4832e6a82905"));
    }

    @Test
    void testTraceEventWithError() {
        TraceEventConverterTest.doTest(TrustyServiceTestUtils.buildTraceEventWithErrors(), TrustyServiceTestUtils.buildDecisionWithErrors());
    }

    @Test
    void testTraceEventWithNullFields() {
        TraceEventConverterTest.doTest(TrustyServiceTestUtils.buildTraceEventWithNullFields(), TrustyServiceTestUtils.buildDecisionWithNullFields());
    }
}

