/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.Message;
import org.kie.kogito.trusty.storage.api.model.MessageExceptionField;
import org.kie.kogito.trusty.storage.api.model.TypedValue;
import org.testcontainers.shaded.org.apache.commons.lang.builder.CompareToBuilder;

public class TraceEventTestUtils {
    public static void assertDecision(Decision expected, Decision actual) {
        Assertions.assertEquals((Object)expected.getExecutionId(), (Object)actual.getExecutionId());
        Assertions.assertSame((Object)expected.getExecutionType(), (Object)actual.getExecutionType());
        Assertions.assertEquals((Long)expected.getExecutionTimestamp(), (Long)actual.getExecutionTimestamp());
        Assertions.assertEquals((Object)expected.getExecutedModelName(), (Object)actual.getExecutedModelName());
        Assertions.assertEquals((Object)expected.getExecutorName(), (Object)actual.getExecutorName());
        TraceEventTestUtils.assertList(expected.getInputs(), actual.getInputs(), TraceEventTestUtils::assertTypedValue, TraceEventTestUtils::compareTypedValue);
        TraceEventTestUtils.assertList(expected.getOutcomes(), actual.getOutcomes(), TraceEventTestUtils::assertDecisionOutcome, TraceEventTestUtils::compareDecisionOutcome);
    }

    public static void assertDecisionOutcome(DecisionOutcome expected, DecisionOutcome actual) {
        Assertions.assertEquals((Object)expected.getOutcomeId(), (Object)actual.getOutcomeId());
        Assertions.assertEquals((Object)expected.getOutcomeName(), (Object)actual.getOutcomeName());
        TraceEventTestUtils.assertTypedValue(expected.getOutcomeResult(), actual.getOutcomeResult());
        Assertions.assertEquals((Object)expected.getEvaluationStatus(), (Object)actual.getEvaluationStatus());
        TraceEventTestUtils.assertList(expected.getOutcomeInputs(), actual.getOutcomeInputs(), TraceEventTestUtils::assertTypedValue, TraceEventTestUtils::compareTypedValue);
        TraceEventTestUtils.assertList(expected.getMessages(), actual.getMessages(), TraceEventTestUtils::assertMessage, TraceEventTestUtils::compareMessage);
    }

    public static <T> void assertList(Collection<T> expected, Collection<T> actual, BiConsumer<T, T> itemAssertor, Comparator<? super T> comparator) {
        if (expected == null && actual == null || expected == null && actual.isEmpty() || actual == null && expected.isEmpty()) {
            return;
        }
        Assertions.assertNotNull(expected);
        Assertions.assertNotNull(actual);
        Assertions.assertSame((Object)expected.size(), (Object)actual.size());
        List sortedExpected = expected.stream().sorted(comparator).collect(Collectors.toList());
        List sortedActual = actual.stream().sorted(comparator).collect(Collectors.toList());
        for (int i = 0; i < sortedExpected.size(); ++i) {
            itemAssertor.accept(sortedExpected.get(0), sortedActual.get(0));
        }
    }

    public static void assertMessage(Message expected, Message actual) {
        Assertions.assertSame((Object)expected.getLevel(), (Object)actual.getLevel());
        Assertions.assertEquals((Object)expected.getCategory(), (Object)actual.getCategory());
        Assertions.assertEquals((Object)expected.getType(), (Object)actual.getType());
        Assertions.assertEquals((Object)expected.getSourceId(), (Object)actual.getSourceId());
        Assertions.assertEquals((Object)expected.getText(), (Object)actual.getText());
        TraceEventTestUtils.assertMessageExceptionField(expected.getException(), actual.getException());
    }

    public static void assertMessageExceptionField(MessageExceptionField expected, MessageExceptionField actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            Assertions.fail();
        }
        Assertions.assertEquals((Object)expected.getMessage(), (Object)actual.getMessage());
        Assertions.assertEquals((Object)expected.getClassName(), (Object)actual.getClassName());
        TraceEventTestUtils.assertMessageExceptionField(expected.getCause(), actual.getCause());
    }

    public static void assertTypedValue(TypedValue expected, TypedValue actual) {
        Assertions.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assertions.assertEquals((Object)expected.getTypeRef(), (Object)actual.getTypeRef());
        Assertions.assertEquals((Object)expected.getValue(), (Object)actual.getValue());
    }

    public static int compareDecisionOutcome(DecisionOutcome expected, DecisionOutcome actual) {
        return new CompareToBuilder().append((Object)expected.getOutcomeId(), (Object)actual.getOutcomeId()).append((Object)expected.getOutcomeName(), (Object)actual.getOutcomeName()).append((Object)expected.getEvaluationStatus(), (Object)actual.getEvaluationStatus()).toComparison();
    }

    public static int compareMessage(Message expected, Message actual) {
        return new CompareToBuilder().append((Object)expected.getLevel(), (Object)actual.getLevel()).append((Object)expected.getCategory(), (Object)actual.getCategory()).append((Object)expected.getType(), (Object)actual.getType()).append((Object)expected.getText(), (Object)actual.getText()).toComparison();
    }

    public static int compareTypedValue(TypedValue expected, TypedValue actual) {
        return new CompareToBuilder().append((Object)expected.getTypeRef(), (Object)actual.getTypeRef()).append((Object)expected.getName(), (Object)actual.getName()).toComparison();
    }
}

