/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.explainability.api.ExplainabilityRequestDto;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.messaging.incoming.ModelIdCreator;
import org.kie.kogito.trusty.service.messaging.outgoing.ExplainabilityRequestProducer;
import org.kie.kogito.trusty.storage.api.TrustyStorageService;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.Execution;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityResult;

@ApplicationScoped
public class TrustyServiceImpl
implements TrustyService {
    @ConfigProperty(name="trusty.explainability.enabled")
    Boolean isExplainabilityEnabled;
    @Inject
    ExplainabilityRequestProducer explainabilityRequestProducer;
    @Inject
    TrustyStorageService storageService;

    TrustyServiceImpl() {
    }

    public TrustyServiceImpl(TrustyStorageService storageService) {
        this.storageService = storageService;
    }

    @Override
    public List<Execution> getExecutionHeaders(OffsetDateTime from, OffsetDateTime to, int limit, int offset, String prefix) {
        Storage storage = this.storageService.getDecisionsStorage();
        ArrayList<AttributeFilter> filters = new ArrayList<AttributeFilter>();
        filters.add(QueryFilterFactory.like((String)"executionId", (String)(prefix + "*")));
        filters.add(QueryFilterFactory.greaterThanEqual((String)"executionTimestamp", (Object)from.toInstant().toEpochMilli()));
        filters.add(QueryFilterFactory.lessThanEqual((String)"executionTimestamp", (Object)to.toInstant().toEpochMilli()));
        return new ArrayList<Execution>(storage.query().limit(Integer.valueOf(limit)).offset(Integer.valueOf(offset)).filter(filters).execute());
    }

    @Override
    public Decision getDecisionById(String executionId) {
        Storage storage = this.storageService.getDecisionsStorage();
        if (!storage.containsKey((Object)executionId)) {
            throw new IllegalArgumentException(String.format("A decision with ID %s does not exist in the storage.", executionId));
        }
        return (Decision)storage.get((Object)executionId);
    }

    @Override
    public void storeDecision(String executionId, Decision decision) {
        Storage storage = this.storageService.getDecisionsStorage();
        if (storage.containsKey((Object)executionId)) {
            throw new IllegalArgumentException(String.format("A decision with ID %s is already present in the storage.", executionId));
        }
        storage.put((Object)executionId, (Object)decision);
    }

    @Override
    public void updateDecision(String executionId, Decision decision) {
        this.storageService.getDecisionsStorage().put((Object)executionId, (Object)decision);
    }

    @Override
    public void processDecision(String executionId, Decision decision) {
        this.storeDecision(executionId, decision);
        if (Boolean.TRUE.equals(this.isExplainabilityEnabled)) {
            this.explainabilityRequestProducer.sendEvent(new ExplainabilityRequestDto(executionId));
        }
    }

    @Override
    public void storeExplainability(String executionId, ExplainabilityResult result) {
    }

    @Override
    public void storeModel(String groupId, String artifactId, String version, String name, String namespace, String definition) {
        String identifier = ModelIdCreator.makeIdentifier(groupId, artifactId, version, name, namespace);
        Storage storage = this.storageService.getModelStorage();
        if (storage.containsKey((Object)identifier)) {
            throw new IllegalArgumentException(String.format("A model with ID %s is already present in the storage.", identifier));
        }
        storage.put((Object)identifier, (Object)definition);
    }

    @Override
    public String getModelById(String modelId) {
        Storage storage = this.storageService.getModelStorage();
        if (!storage.containsKey((Object)modelId)) {
            throw new IllegalArgumentException(String.format("A model with ID %s does not exist in the storage.", modelId));
        }
        return (String)storage.get((Object)modelId);
    }
}

