/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.api;

import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.jboss.resteasy.annotations.jaxrs.PathParam;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.responses.DecisionOutcomeResponse;
import org.kie.kogito.trusty.service.responses.DecisionOutcomesResponse;
import org.kie.kogito.trusty.service.responses.DecisionStructuredInputsResponse;
import org.kie.kogito.trusty.service.responses.ExecutionHeaderResponse;
import org.kie.kogito.trusty.storage.api.model.Decision;

@Path(value="v1/executions/decisions")
public class DecisionsApiV1 {
    @Inject
    TrustyService trustyService;

    @GET
    @Path(value="/{executionId}")
    @APIResponses(value={@APIResponse(description="Gets the decision detail header.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=ExecutionHeaderResponse.class))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Gets The decision header with details.", description="Gets the decision detail header.")
    @Produces(value={"application/json"})
    public Response getExecutionById(@Parameter(name="executionId", description="The execution ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="executionId") String executionId) {
        return this.handleDecisionRequest(executionId, ExecutionHeaderResponse::fromExecution);
    }

    @GET
    @Path(value="/{executionId}/structuredInputs")
    @APIResponses(value={@APIResponse(description="Gets the decision structured inputs.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=DecisionStructuredInputsResponse.class))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Gets the decision structured inputs.")
    @Produces(value={"application/json"})
    public Response getStructuredInputs(@Parameter(name="executionId", description="The execution ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="executionId") String executionId) {
        return this.handleDecisionRequest(executionId, DecisionStructuredInputsResponse::from);
    }

    @GET
    @Path(value="/{executionId}/outcomes")
    @APIResponses(value={@APIResponse(description="Gets the decision outcomes.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=DecisionOutcomesResponse.class))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Gets the decision outcomes.")
    @Produces(value={"application/json"})
    public Response getOutcomes(@Parameter(name="executionId", description="The execution ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="executionId") String executionId) {
        return this.handleDecisionRequest(executionId, DecisionOutcomesResponse::from);
    }

    @GET
    @Path(value="/{executionId}/outcomes/{outcomeId}")
    @APIResponses(value={@APIResponse(description="Gets a specific outcome of a decision.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=DecisionOutcomeResponse.class))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Gets a specific outcome of a decision.")
    @Produces(value={"application/json"})
    public Response getOutcomeById(@Parameter(name="executionId", description="The execution ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="executionId") String executionId, @Parameter(name="outcomeId", description="The outcome ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="outcomeId") String outcomeId) {
        return this.handleDecisionRequest(executionId, decision -> decision.getOutcomes() == null ? null : decision.getOutcomes().stream().filter(outcome -> outcomeId != null && outcomeId.equals(outcome.getOutcomeId())).findFirst().map(DecisionOutcomeResponse::from).orElse(null));
    }

    private Response handleDecisionRequest(String executionId, Function<Decision, Object> transformer) {
        return this.retrieveDecision(executionId).map(transformer).map(obj -> Response.ok((Object)obj).build()).orElseGet(() -> Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).build());
    }

    private Optional<Decision> retrieveDecision(String executionId) {
        try {
            return Optional.of(this.trustyService.getDecisionById(executionId));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }
}

