/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudevents.v1.CloudEventImpl;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.kie.kogito.trusty.service.TrustyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEventConsumer<E> {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseEventConsumer.class);
    protected final TrustyService service;

    protected BaseEventConsumer() {
        this(null);
    }

    public BaseEventConsumer(TrustyService service) {
        this.service = service;
    }

    protected CompletionStage<Void> handleMessage(Message<String> message) {
        try {
            this.decodeCloudEvent((String)message.getPayload()).ifPresent(this::handleCloudEvent);
        }
        catch (Exception e) {
            LOG.error("Something unexpected happened during the processing of an Event. The event is discarded.", (Throwable)e);
        }
        return message.ack();
    }

    protected Optional<CloudEventImpl<E>> decodeCloudEvent(String payload) {
        try {
            return Optional.of(CloudEventUtils.decode((String)payload, this.getCloudEventType()));
        }
        catch (IllegalStateException e) {
            LOG.error(String.format("Can't decode message to CloudEvent: %s", payload), (Throwable)e);
            return Optional.empty();
        }
    }

    protected abstract TypeReference<CloudEventImpl<E>> getCloudEventType();

    protected abstract void handleCloudEvent(CloudEventImpl<E> var1);
}

