/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudevents.v1.AttributesImpl;
import io.cloudevents.v1.CloudEventImpl;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.explainability.api.ExplainabilityResultDto;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.messaging.BaseEventConsumer;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExplainabilityResultConsumer
extends BaseEventConsumer<ExplainabilityResultDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplainabilityResultConsumer.class);
    private static final TypeReference<CloudEventImpl<ExplainabilityResultDto>> CLOUD_EVENT_TYPE = new TypeReference<CloudEventImpl<ExplainabilityResultDto>>(){};

    private ExplainabilityResultConsumer() {
    }

    @Inject
    public ExplainabilityResultConsumer(TrustyService service) {
        super(service);
    }

    @Override
    @Incoming(value="trusty-explainability-result")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        return super.handleMessage(message);
    }

    @Override
    protected TypeReference<CloudEventImpl<ExplainabilityResultDto>> getCloudEventType() {
        return CLOUD_EVENT_TYPE;
    }

    @Override
    protected void handleCloudEvent(CloudEventImpl<ExplainabilityResultDto> cloudEvent) {
        AttributesImpl attributes = cloudEvent.getAttributes();
        Optional optData = cloudEvent.getData();
        if (!optData.isPresent()) {
            LOGGER.error("Received CloudEvent with id {} from {} with empty data", (Object)attributes.getId(), (Object)attributes.getSource());
            return;
        }
        LOGGER.info("Received CloudEvent with id {} from {}", (Object)attributes.getId(), (Object)attributes.getSource());
        ExplainabilityResultDto explainabilityResult = (ExplainabilityResultDto)optData.get();
        this.service.storeExplainability(attributes.getId(), ExplainabilityResult.from((ExplainabilityResultDto)explainabilityResult));
    }
}

