/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudevents.v1.AttributesImpl;
import io.cloudevents.v1.CloudEventImpl;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.decision.DecisionModelType;
import org.kie.kogito.tracing.decision.event.model.ModelEvent;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.messaging.BaseEventConsumer;
import org.kie.kogito.trusty.service.messaging.incoming.ModelEventConverter;

@ApplicationScoped
public class ModelEventConsumer
extends BaseEventConsumer<ModelEvent> {
    private static final TypeReference<CloudEventImpl<ModelEvent>> CLOUD_EVENT_TYPE_REF = new TypeReference<CloudEventImpl<ModelEvent>>(){};

    private ModelEventConsumer() {
    }

    @Inject
    public ModelEventConsumer(TrustyService service) {
        super(service);
    }

    @Override
    @Incoming(value="kogito-tracing-model")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        return super.handleMessage(message);
    }

    @Override
    protected TypeReference<CloudEventImpl<ModelEvent>> getCloudEventType() {
        return CLOUD_EVENT_TYPE_REF;
    }

    @Override
    protected void handleCloudEvent(CloudEventImpl<ModelEvent> cloudEvent) {
        AttributesImpl attributes = cloudEvent.getAttributes();
        Optional optData = cloudEvent.getData();
        if (!optData.isPresent()) {
            LOG.error("Received CloudEvent with id {} from {} with empty data", (Object)attributes.getId(), (Object)attributes.getSource());
            return;
        }
        LOG.debug("Received CloudEvent with id {} from {}", (Object)attributes.getId(), (Object)attributes.getSource());
        ModelEvent modelEvent = (ModelEvent)optData.get();
        DecisionModelType modelEventType = modelEvent.getType();
        if (modelEventType == DecisionModelType.DMN) {
            this.service.storeModel(modelEvent.getGav().getGroupId(), modelEvent.getGav().getArtifactId(), modelEvent.getGav().getVersion(), modelEvent.getName(), modelEvent.getNamespace(), ModelEventConverter.toModel(modelEvent));
        } else {
            LOG.error("Unsupported DecisionModelType type {}", (Object)modelEventType);
        }
    }
}

