/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.explainability.api.ExplainabilityRequestDto;
import org.kie.kogito.explainability.api.ModelIdentifierDto;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.messaging.MessagingUtils;
import org.kie.kogito.trusty.service.messaging.incoming.ModelIdCreator;
import org.kie.kogito.trusty.service.messaging.outgoing.ExplainabilityRequestProducer;
import org.kie.kogito.trusty.service.models.MatchedExecutionHeaders;
import org.kie.kogito.trusty.storage.api.TrustyStorageService;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TrustyServiceImpl
implements TrustyService {
    private static final Logger LOG = LoggerFactory.getLogger(TrustyServiceImpl.class);
    private boolean isExplainabilityEnabled;
    private ExplainabilityRequestProducer explainabilityRequestProducer;
    private TrustyStorageService storageService;

    TrustyServiceImpl() {
    }

    @Inject
    public TrustyServiceImpl(@ConfigProperty(name="trusty.explainability.enabled") Boolean isExplainabilityEnabled, ExplainabilityRequestProducer explainabilityRequestProducer, TrustyStorageService storageService) {
        this.isExplainabilityEnabled = Boolean.TRUE.equals(isExplainabilityEnabled);
        this.explainabilityRequestProducer = explainabilityRequestProducer;
        this.storageService = storageService;
    }

    void enableExplainability() {
        this.isExplainabilityEnabled = true;
    }

    @Override
    public MatchedExecutionHeaders getExecutionHeaders(OffsetDateTime from, OffsetDateTime to, int limit, int offset, String prefix) {
        Storage storage = this.storageService.getDecisionsStorage();
        ArrayList<AttributeFilter> filters = new ArrayList<AttributeFilter>();
        filters.add(QueryFilterFactory.like((String)"executionId", (String)(prefix + "*")));
        filters.add(QueryFilterFactory.greaterThanEqual((String)"executionTimestamp", (Object)from.toInstant().toEpochMilli()));
        filters.add(QueryFilterFactory.lessThanEqual((String)"executionTimestamp", (Object)to.toInstant().toEpochMilli()));
        ArrayList result = new ArrayList(storage.query().sort(Arrays.asList(QueryFilterFactory.orderBy((String)"executionTimestamp", (SortDirection)SortDirection.DESC))).filter(filters).execute());
        if (result.size() < offset) {
            throw new IllegalArgumentException("Out of bound start offset in result");
        }
        return new MatchedExecutionHeaders(result.subList(offset, Math.min(offset + limit, result.size())), result.size());
    }

    @Override
    public Decision getDecisionById(String executionId) {
        Storage storage = this.storageService.getDecisionsStorage();
        if (!storage.containsKey((Object)executionId)) {
            throw new IllegalArgumentException(String.format("A decision with ID %s does not exist in the storage.", executionId));
        }
        return (Decision)storage.get((Object)executionId);
    }

    @Override
    public void storeDecision(String executionId, Decision decision) {
        Storage storage = this.storageService.getDecisionsStorage();
        if (storage.containsKey((Object)executionId)) {
            throw new IllegalArgumentException(String.format("A decision with ID %s is already present in the storage.", executionId));
        }
        storage.put((Object)executionId, (Object)decision);
    }

    @Override
    public void updateDecision(String executionId, Decision decision) {
        this.storageService.getDecisionsStorage().put((Object)executionId, (Object)decision);
    }

    @Override
    public void processDecision(String executionId, String serviceUrl, Decision decision) {
        this.storeDecision(executionId, decision);
        if (this.isExplainabilityEnabled) {
            Map inputs = decision.getInputs() != null ? (Map)decision.getInputs().stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), MessagingUtils.modelToTracingTypedValue(v.getValue())), HashMap::putAll) : Collections.emptyMap();
            Map outputs = decision.getOutcomes() != null ? (Map)decision.getOutcomes().stream().collect(HashMap::new, (m, v) -> m.put(v.getOutcomeName(), MessagingUtils.modelToTracingTypedValue(v.getOutcomeResult())), HashMap::putAll) : Collections.emptyMap();
            this.explainabilityRequestProducer.sendEvent(new ExplainabilityRequestDto(executionId, serviceUrl, this.createDecisionModelIdentifierDto(decision), inputs, outputs));
        }
    }

    @Override
    public ExplainabilityResult getExplainabilityResultById(String executionId) {
        Storage storage = this.storageService.getExplainabilityResultStorage();
        if (!storage.containsKey((Object)executionId)) {
            throw new IllegalArgumentException(String.format("A explainability result with ID %s does not exist in the storage.", executionId));
        }
        return (ExplainabilityResult)storage.get((Object)executionId);
    }

    @Override
    public void storeExplainabilityResult(String executionId, ExplainabilityResult result) {
        Storage storage = this.storageService.getExplainabilityResultStorage();
        if (storage.containsKey((Object)executionId)) {
            throw new IllegalArgumentException(String.format("A explainability result with ID %s is already present in the storage.", executionId));
        }
        storage.put((Object)executionId, (Object)result);
        LOG.info("Stored explainability result for execution {}", (Object)executionId);
    }

    @Override
    public void storeModel(String groupId, String artifactId, String version, String name, String namespace, String definition) {
        String identifier = ModelIdCreator.makeIdentifier(groupId, artifactId, version, name, namespace);
        Storage storage = this.storageService.getModelStorage();
        if (storage.containsKey((Object)identifier)) {
            throw new IllegalArgumentException(String.format("A model with ID %s is already present in the storage.", identifier));
        }
        storage.put((Object)identifier, (Object)definition);
    }

    @Override
    public String getModelById(String modelId) {
        Storage storage = this.storageService.getModelStorage();
        if (!storage.containsKey((Object)modelId)) {
            throw new IllegalArgumentException(String.format("A model with ID %s does not exist in the storage.", modelId));
        }
        return (String)storage.get((Object)modelId);
    }

    private ModelIdentifierDto createDecisionModelIdentifierDto(Decision decision) {
        String resourceId = decision.getExecutedModelNamespace() + ":" + decision.getExecutedModelName();
        return new ModelIdentifierDto("dmn", resourceId);
    }
}

